/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.excel.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

public class ChunkedBufferByteArrayOutputStream
extends OutputStream {
    public static final int DEFULAT_CHUNKED_BUFFER_SIZE = 512;
    protected int chunkedBufferSize;
    protected List buffers;
    protected int currentPos;
    protected byte[] currentByteArray;

    public ChunkedBufferByteArrayOutputStream(int chunkedBufSize) {
        this.chunkedBufferSize = chunkedBufSize;
        this.buffers = new LinkedList();
        this.appendNewBuffer();
    }

    public ChunkedBufferByteArrayOutputStream() {
        this(512);
    }

    protected void appendNewBuffer() {
        this.currentPos = 0;
        this.currentByteArray = new byte[this.chunkedBufferSize];
        this.buffers.add(this.currentByteArray);
    }

    public void write(int b) throws IOException {
        if (this.currentPos == this.chunkedBufferSize) {
            this.appendNewBuffer();
        }
        this.currentByteArray[this.currentPos++] = (byte)b;
    }

    public void write(byte[] bs, int off, int len) throws IOException {
        while (len > 0) {
            int filledLen;
            if (this.currentPos == this.chunkedBufferSize) {
                this.appendNewBuffer();
            }
            if (len < (filledLen = this.chunkedBufferSize - this.currentPos)) {
                filledLen = len;
            }
            System.arraycopy(bs, off, this.currentByteArray, this.currentPos, filledLen);
            off += filledLen;
            len -= filledLen;
            this.currentPos += filledLen;
        }
    }

    public void write(byte[] bs) throws IOException {
        this.write(bs, 0, bs.length);
    }
}

