/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.excel.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import jp.sourceforge.excel.plugin.ChunkedBufferByteArrayInputStream;
import jp.sourceforge.excel.plugin.ChunkedBufferByteArrayOutputStream;
import jp.sourceforge.poi.util.PoiUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;

public class ExcelEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    protected static final PoiUtil poiUtil = PoiUtil.getPoiUtil();
    boolean dirty;
    private Table[] tables;
    protected HSSFWorkbook workbook;

    public ExcelEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.dirty = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createExcelPage() throws IOException, CoreException {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof IFileEditorInput)) return;
        IFileEditorInput fileInput = (IFileEditorInput)input;
        IFile ifile = fileInput.getFile();
        InputStream in = null;
        try {
            int i;
            in = ifile.getContents();
            POIFSFileSystem fs = null;
            fs = new POIFSFileSystem(in);
            this.workbook = new HSSFWorkbook(fs);
            this.workbook.getCustomPalette();
            LinkedList<String> colNamesList = new LinkedList<String>();
            char c = 'A';
            while (true) {
                if (c > 'Z') break;
                colNamesList.add(new String(new char[]{c}));
                c = (char)(c + 1);
            }
            char c0 = 'A';
            block7: while (true) {
                if (c0 > 'H') break;
                char c1 = 'A';
                while (true) {
                    if (c1 > 'Z') {
                        c0 = (char)(c0 + 1);
                        continue block7;
                    }
                    colNamesList.add(new String(new char[]{c0, c1}));
                    c1 = (char)(c1 + 1);
                }
                break;
            }
            c = 'A';
            while (true) {
                if (c > 'V') {
                    this.tables = new Table[this.workbook.getNumberOfSheets()];
                    i = 0;
                    break;
                }
                colNamesList.add(new String(new char[]{'I', c}));
                c = (char)(c + 1);
            }
            block10: while (i < this.workbook.getNumberOfSheets()) {
                final HSSFSheet sheet = this.workbook.getSheetAt(i);
                String sheetName = this.workbook.getSheetName(i);
                final Table table = new Table(this.getContainer(), 66308);
                table.setHeaderVisible(true);
                int j = 0;
                while (true) {
                    if (j >= colNamesList.size()) break;
                    TableColumn col = new TableColumn(table, 16384);
                    col.setText((String)colNamesList.get(j));
                    col.setWidth(50);
                    ++j;
                }
                int row = sheet.getFirstRowNum();
                while (true) {
                    if (row > sheet.getLastRowNum()) {
                        final TableEditor tableEditor = new TableEditor(table);
                        tableEditor.grabHorizontal = true;
                        table.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDown(MouseEvent e) {
                                int index = table.getSelectionIndex();
                                if (index == -1) {
                                    return;
                                }
                                table.setSelection(new int[0]);
                                TableItem item = table.getItem(index);
                                Point point = new Point(e.x, e.y);
                                int i = 0;
                                while (i < table.getColumnCount()) {
                                    int row = i;
                                    if (item.getBounds(i).contains(point)) {
                                        int column = i;
                                        Text text = new Text((Composite)table, 0);
                                        text.setText(item.getText(i));
                                        text.addFocusListener((FocusListener)new FocusAdapter(this, sheet, row, index, text, tableEditor, column){
                                            final /* synthetic */ 1 this$1;
                                            private final /* synthetic */ HSSFSheet val$sheet;
                                            private final /* synthetic */ int val$row;
                                            private final /* synthetic */ int val$index;
                                            private final /* synthetic */ Text val$text;
                                            private final /* synthetic */ TableEditor val$tableEditor;
                                            private final /* synthetic */ int val$column;
                                            {
                                                this.this$1 = var1_1;
                                                this.val$sheet = hSSFSheet;
                                                this.val$row = n;
                                                this.val$index = n2;
                                                this.val$text = text;
                                                this.val$tableEditor = tableEditor;
                                                this.val$column = n3;
                                            }

                                            public void focusLost(FocusEvent e) {
                                                1.access$0(this.this$1).setSheetValue(this.val$sheet, this.val$row, this.val$index, this.val$text.getText());
                                                1.access$0(this.this$1).setDirty(true);
                                                TableItem item = this.val$tableEditor.getItem();
                                                item.setText(this.val$column, this.val$text.getText());
                                                this.val$text.dispose();
                                            }
                                        });
                                        tableEditor.setEditor((Control)text, item, i);
                                        text.setFocus();
                                        text.selectAll();
                                    }
                                    ++i;
                                }
                            }

                            static /* synthetic */ ExcelEditor access$0(1 var0) {
                                return var0.ExcelEditor.this;
                            }
                        });
                        this.tables[i] = table;
                        int index = this.addPage((Control)table);
                        this.setPageText(index, sheetName);
                        ++i;
                        continue block10;
                    }
                    HSSFRow rowValue = sheet.getRow(row);
                    if (rowValue != null) {
                        TableItem item = new TableItem(table, 0);
                        LinkedList<String> colValuesList = new LinkedList<String>();
                        short col = 0;
                        while (true) {
                            if (col >= rowValue.getFirstCellNum()) break;
                            colValuesList.add("");
                            col = (short)(col + 1);
                        }
                        col = rowValue.getFirstCellNum();
                        while (true) {
                            if (col > rowValue.getLastCellNum()) {
                                String[] data = colValuesList.toArray(new String[colValuesList.size()]);
                                item.setText(data);
                                break;
                            }
                            HSSFCell cell = rowValue.getCell(col);
                            colValuesList.add(cell == null ? "" : poiUtil.getCellValueAsString(cell));
                            if (cell != null) {
                                short cellColor = cell.getCellStyle().getFillBackgroundColor();
                                HSSFColor bgcolor = (HSSFColor)PoiUtil.colorMap.get(new Short(cellColor));
                                if (bgcolor == null) {
                                    bgcolor = new HSSFColor.WHITE();
                                }
                                short[] triplet = bgcolor.getTriplet();
                                item.setBackground((int)col, new Color((Device)item.getDisplay(), (int)triplet[0], (int)triplet[1], (int)triplet[2]));
                            }
                            col = (short)(col + 1);
                        }
                    }
                    ++row;
                }
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var20_27 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (in == null) return;
        in.close();
    }

    protected void createPages() {
        try {
            this.createExcelPage();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            ChunkedBufferByteArrayOutputStream out = new ChunkedBufferByteArrayOutputStream();
            try {
                this.workbook.write((OutputStream)out);
                out.close();
                ChunkedBufferByteArrayInputStream stream = new ChunkedBufferByteArrayInputStream(out);
                file.setContents((InputStream)stream, true, true, monitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void setDirty(boolean dirty) {
        if (!this.dirty && dirty) {
            this.setPartName("*" + this.getPartName());
        }
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ExcelEditor.this.getSite().getWorkbenchWindow().getPages();
                }
            });
        }
    }

    public void setSheetValue(HSSFSheet sheet, int col, int row, String value) {
        HSSFRow rowValue = sheet.getRow(row);
        if (rowValue == null) {
            return;
        }
        HSSFCell cell = rowValue.getCell((short)col);
        if (cell == null) {
            cell = rowValue.createCell((short)col);
            cell.setCellValue(value);
        } else {
            String cellValue = poiUtil.getCellValueAsString(cell);
            if (cellValue == null || !cellValue.equals(value)) {
                cell.setCellValue(value);
            }
        }
    }
}

