/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.poi.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sourceforge.poi.bean.Table;
import jp.sourceforge.poi.parser.Parser;
import jp.sourceforge.poi.parser.ParserResult;
import jp.sourceforge.poi.util.SheetNotFoundException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class PoiUtil {
    protected static PoiUtil util = new PoiUtil();
    private static HSSFColor[] colors = new HSSFColor[]{new HSSFColor.AQUA(), new HSSFColor.BLACK(), new HSSFColor.BLUE(), new HSSFColor.BLUE_GREY(), new HSSFColor.BRIGHT_GREEN(), new HSSFColor.BROWN(), new HSSFColor.CORAL(), new HSSFColor.CORNFLOWER_BLUE(), new HSSFColor.DARK_BLUE(), new HSSFColor.DARK_GREEN(), new HSSFColor.DARK_RED(), new HSSFColor.DARK_TEAL(), new HSSFColor.DARK_YELLOW(), new HSSFColor.GOLD(), new HSSFColor.GREEN(), new HSSFColor.GREY_25_PERCENT(), new HSSFColor.GREY_40_PERCENT(), new HSSFColor.GREY_50_PERCENT(), new HSSFColor.GREY_80_PERCENT(), new HSSFColor.INDIGO(), new HSSFColor.LAVENDER(), new HSSFColor.LEMON_CHIFFON(), new HSSFColor.LIGHT_BLUE(), new HSSFColor.LIGHT_CORNFLOWER_BLUE(), new HSSFColor.LIGHT_GREEN(), new HSSFColor.LIGHT_ORANGE(), new HSSFColor.LIGHT_TURQUOISE(), new HSSFColor.LIGHT_YELLOW(), new HSSFColor.LIME(), new HSSFColor.MAROON(), new HSSFColor.OLIVE_GREEN(), new HSSFColor.ORANGE(), new HSSFColor.ORCHID(), new HSSFColor.PALE_BLUE(), new HSSFColor.PINK(), new HSSFColor.PLUM(), new HSSFColor.RED(), new HSSFColor.ROSE(), new HSSFColor.ROYAL_BLUE(), new HSSFColor.SEA_GREEN(), new HSSFColor.SKY_BLUE(), new HSSFColor.TAN(), new HSSFColor.TEAL(), new HSSFColor.TURQUOISE(), new HSSFColor.VIOLET(), new HSSFColor.WHITE(), new HSSFColor.YELLOW()};
    public static final Map colorMap;

    static {
        HashMap<Short, HSSFColor> internalColorMap = new HashMap<Short, HSSFColor>();
        int i = 0;
        while (i < colors.length) {
            HSSFColor color = colors[i];
            internalColorMap.put(new Short(color.getIndex()), color);
            ++i;
        }
        colorMap = Collections.unmodifiableMap(internalColorMap);
    }

    protected PoiUtil() {
    }

    public static PoiUtil getPoiUtil() {
        return util;
    }

    public Table getValues(InputStream in, int sheetIndex, int startCol, int startRow, int columnSize, int rowSize) throws IOException, SheetNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(sheetIndex);
        if (sheet == null) {
            throw new SheetNotFoundException("Sheet at " + sheetIndex + " not found");
        }
        return this.getValues(sheet, startCol, startRow, columnSize, rowSize);
    }

    public Table getValues(InputStream in, String sheetName, int startCol, int startRow, int columnSize, int rowSize) throws IOException, SheetNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            throw new SheetNotFoundException("Sheet " + sheetName + " not found");
        }
        return this.getValues(sheet, startCol, startRow, columnSize, rowSize);
    }

    public Table getValues(HSSFSheet sheet, int startCol, int startRow, int colSize, int rowSize) {
        TableImpl table = new TableImpl(colSize, rowSize);
        int row = startRow;
        while (row < startRow + rowSize) {
            HSSFRow rowValue = sheet.getRow(row);
            int col = startCol;
            while (col < startCol + colSize) {
                HSSFCell cellValue = rowValue.getCell((short)col);
                String value = this.getCellValueAsString(cellValue);
                table.set(col - startCol, row - startRow, value);
                ++col;
            }
            ++row;
        }
        return table;
    }

    public Table getValues(InputStream in, int sheetIndex, int startCol, int startRow, Parser parser) throws IOException, SheetNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(sheetIndex);
        if (sheet == null) {
            throw new SheetNotFoundException("Sheet at " + sheetIndex + " not found");
        }
        return this.getValues(sheet, startCol, startRow, parser);
    }

    public Table getValues(InputStream in, String sheetName, int startCol, int startRow, Parser parser) throws IOException, SheetNotFoundException {
        POIFSFileSystem fs = new POIFSFileSystem(in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            throw new SheetNotFoundException("Sheet " + sheetName + " not found");
        }
        return this.getValues(sheet, startCol, startRow, parser);
    }

    public Table getValues(HSSFSheet sheet, int startCol, int startRow, Parser parser) {
        ParseIterator iter = new ParseIterator(sheet, parser, startCol, startRow);
        if (!iter.hasNext()) {
            return null;
        }
        Object[] os = (Object[])iter.next();
        DynaTableImpl table = new DynaTableImpl(os.length);
        table.addRow(os);
        while (iter.hasNext()) {
            os = (Object[])iter.next();
            table.addRow(os);
        }
        return table;
    }

    public Iterator getValuesAsIterator(HSSFSheet sheet, int startCol, int startRow, Parser parser) {
        return new ParseIterator(sheet, parser, startCol, startRow);
    }

    public String getCellValueAsString(HSSFCell cellValue) {
        String value = null;
        if (cellValue != null) {
            int cellType = cellValue.getCellType();
            switch (cellType) {
                case 1: {
                    value = cellValue.getStringCellValue();
                    break;
                }
                case 0: 
                case 2: {
                    short format = cellValue.getCellStyle().getDataFormat();
                    if (HSSFDateUtil.isInternalDateFormat((int)format)) {
                        Date d = cellValue.getDateCellValue();
                        if (format == 22 || format == 176) {
                            DateFormat.getDateTimeInstance().format(d);
                            break;
                        }
                        DateFormat.getDateInstance().format(d);
                        break;
                    }
                    double dval = cellValue.getNumericCellValue();
                    value = dval == (double)((short)dval) ? Short.toString((short)dval) : Double.toString(dval);
                }
            }
        }
        if (cellValue == null) {
            value = "";
        }
        return value;
    }

    public void setValues(HSSFSheet sheet, int startCol, int startRow, Table table) {
        int rowSize = table.getRowSize();
        int colSize = table.getColumnSize();
        int row = 0;
        while (row < startRow + rowSize) {
            HSSFRow rowValue = sheet.getRow(row);
            int col = 0;
            while (col < colSize) {
                HSSFCell cellValue = rowValue.getCell((short)col);
                Object value = table.get(startCol + col, startRow + row);
                cellValue.setCellValue(value.toString());
                ++col;
            }
            ++row;
        }
    }

    public int convertColumnCellNameToIndex(String colName) {
        if (colName.length() == 1) {
            char c = colName.charAt(0);
            c = Character.toUpperCase(c);
            return c - 65;
        }
        if (colName.length() == 2) {
            char c0 = Character.toUpperCase(colName.charAt(0));
            char c1 = Character.toUpperCase(colName.charAt(1));
            return 26 * (c0 - 65) + c1 - 65 + 26;
        }
        throw new RuntimeException("column " + colName + " not valid");
    }

    class ParseIterator
    implements Iterator {
        Parser parser;
        HSSFSheet sheet;
        int startCol;
        int row;
        Object nextValue;
        boolean hasNext = true;

        public ParseIterator(HSSFSheet sheet, Parser parser, int startCol, int startRow) {
            this.startCol = startCol;
            this.row = startRow;
            this.sheet = sheet;
            this.parser = parser;
            parser.setStartColumn(startCol);
            parser.setStartRow(startRow);
        }

        public boolean hasNext() {
            if (!this.hasNext) {
                return false;
            }
            HSSFRow rowValue = this.sheet.getRow(this.row);
            if (rowValue == null) {
                this.hasNext = false;
                return false;
            }
            this.parser.setCurrentRow(this.row);
            ParserResult result = this.parser.parse(rowValue);
            if (result.isParseBreak()) {
                this.hasNext = false;
            }
            ++this.row;
            this.nextValue = result.getResultValue();
            return this.hasNext;
        }

        public Object next() {
            return this.nextValue;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class TableImpl
    implements Table {
        private int columnSize;
        private int rowSize;
        private Object[] values;

        public TableImpl(int columnSize, int rowSize) {
            if (rowSize <= 0) {
                throw new RuntimeException("rowSize must be a positive value.");
            }
            if (columnSize <= 0) {
                throw new RuntimeException("columnSize must be a positive value.");
            }
            this.values = new Object[rowSize * columnSize];
            this.columnSize = columnSize;
            this.rowSize = rowSize;
        }

        public int getRowSize() {
            return this.rowSize;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public Object get(int col, int row) {
            return this.values[row * this.columnSize + col];
        }

        public void set(int col, int row, Object value) {
            this.values[row * this.columnSize + col] = value;
        }
    }

    class DynaTableImpl
    implements Table {
        List table = new ArrayList();
        private int columnSize;

        public DynaTableImpl(int columnSize) {
            this.columnSize = columnSize;
        }

        public int getRowSize() {
            return this.table.size();
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public Object get(int col, int row) {
            String[] rowValue = (String[])this.table.get(row);
            return rowValue[col];
        }

        public void set(int col, int row, Object value) {
            Object[] rowValue = (Object[])this.table.get(row);
            rowValue[col] = value;
        }

        public void addRow(Object[] rowValue) {
            if (rowValue.length != this.columnSize) {
                throw new RuntimeException("rowValue.length != columnSize");
            }
            this.table.add(rowValue);
        }
    }
}

