/*
 * $Id: AbstractParser.java,v 1.1 2005/06/12 11:12:39 velvet Exp $
 * 
 * Copyright 2000-2005 The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package jp.sourceforge.poi.parser;

import jp.sourceforge.poi.util.PoiUtil;

import org.apache.poi.hssf.usermodel.HSSFRow;


abstract public class AbstractParser implements Parser {
    protected int checkedCellColumnIndex;

    protected int startCol;

    protected int startRow;

    protected int row;

    protected int colSize;

    final public static PoiUtil poiUtil = PoiUtil.getPoiUtil();

    public AbstractParser(int checkedCellColumnIndex, int colSize) {
        this.checkedCellColumnIndex = checkedCellColumnIndex;
        this.colSize = colSize;
    }

    public void setStartColumn(int startCol) {
        this.startCol = startCol;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setCurrentRow(int row) {
        this.row = row;
    }

    public ParserResult parse(HSSFRow rowValue) {
        ParserResult result = new ParserResult();

        Object resutlValue = parseNext(rowValue);
        
        result.setResultValue(resutlValue);
        result.setParseBreak(isBreakRow(rowValue));
        
        return result;
    }

    abstract protected boolean isBreakRow(HSSFRow rowValue);

    abstract protected Object parseNext(HSSFRow rowValue);

}
