/*
 * $Id: BorderStyleParser.java,v 1.1 2005/06/12 11:12:39 velvet Exp $
 * 
 * Copyright 2000-2005 The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package jp.sourceforge.poi.parser;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;

public class BorderStyleParser extends ParserAsStringArrayResult {
    private short borderStyle;

    private boolean hasNext;

    public BorderStyleParser(int checkedCell, int colSize, short borderStyle) {
        super(checkedCell, colSize);
        this.borderStyle = borderStyle;
        this.hasNext = true;
    }

    protected boolean isBreakRow(HSSFRow rowValue) {
        prepareValues(rowValue);
        if (!hasNext)
            return true;
        HSSFCell cell = rowValue.getCell((short) checkedCellColumnIndex);
        HSSFCellStyle style = cell.getCellStyle();
        short border = style.getBorderBottom();
        hasNext = border != borderStyle;
        return false;
    }

    protected boolean isBreakRow(String[] values) {
        throw new RuntimeException("never be called");
    }
}
