/*
 * $Id: CounterParser.java,v 1.1 2005/06/12 11:12:39 velvet Exp $
 * 
 * Copyright 2000-2005 The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package jp.sourceforge.poi.parser;

import jp.sourceforge.poi.util.PoiUtil;

public class CounterParser extends ParserAsStringArrayResult {
    private int number;

    final public static PoiUtil poiUtil = PoiUtil.getPoiUtil();

    public CounterParser(int checkedCellColumnIndex, int colSize) {
        this(checkedCellColumnIndex, colSize, 1);
    }

    public CounterParser(int checkedCellColumnIndex, int colSize, int baseNumber) {
        super(checkedCellColumnIndex, colSize);
        this.number = baseNumber;
    }

    protected boolean isBreakRow(String[] values) {
        String targetValue = values[checkedCellColumnIndex - startCol];
        try {
            if (targetValue == null || number != Integer.parseInt(targetValue)) {
                return true;
            }
        } catch (NumberFormatException ex) {
            return true;
        }
        number++;
        return false;
    }

}
