/*
 * $Id: ParserAsStringArrayResult.java,v 1.1 2005/06/12 11:12:39 velvet Exp $
 * 
 * Copyright 2000-2005 The Apache Software Foundation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package jp.sourceforge.poi.parser;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;

abstract public class ParserAsStringArrayResult extends AbstractParser {

    protected String[] values;

    public ParserAsStringArrayResult(int checkedCellColumnIndex, int colSize) {
        super(checkedCellColumnIndex, colSize);
    }

    abstract protected boolean isBreakRow(String[] values);

    protected boolean isBreakRow(HSSFRow rowValue) {
        return isBreakRow(values);
    }
    
    protected Object parseNext(HSSFRow rowValue) {
        prepareValues(rowValue);
        
        return values;
    }

    protected void prepareValues(HSSFRow rowValue) {
        values = new String[colSize];
        for (int col = 0; col < colSize; col++) {
            HSSFCell cellValue = rowValue.getCell((short) (startCol + col));
            values[col] = poiUtil.getCellValueAsString(cellValue);
        }
    }
}
