package jp.sourceforge.poi.junit;

import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.poi.bean.Table;
import jp.sourceforge.poi.parser.BlankDetectionParser;
import jp.sourceforge.poi.util.PoiUtil;
import jp.sourceforge.poi.util.SheetNotFoundException;
import junit.framework.TestCase;


public class BlankDetectionParserTest extends TestCase {
    protected InputStream getInputStream() {
        return this.getClass().getResourceAsStream("PoiUtilTest.xls");
    }

    public void testParse() {
        PoiUtil util = PoiUtil.getPoiUtil();
        InputStream in = getInputStream();
        try {
            BlankDetectionParser parser = new BlankDetectionParser(2, 3);
            Table table = util.getValues(in, "blank", 1, 1, parser);

            assertEquals(4, table.getRowSize());
            assertEquals(3, table.getColumnSize());

            assertEquals("2", ((String) table.get(0, 0)).trim());
            assertEquals("B:0,0", ((String) table.get(1, 0)).trim());
            assertEquals("B:1,0", ((String) table.get(2, 0)).trim());

            assertEquals("3", ((String) table.get(0, 1)).trim());
            assertEquals("B:0,1", ((String) table.get(1, 1)).trim());
            assertEquals("B:1,1", ((String) table.get(2, 1)).trim());

            assertEquals("4", ((String) table.get(0, 2)).trim());
            assertEquals("B:0,2", ((String) table.get(1, 2)).trim());
            assertEquals("B:1,2", ((String) table.get(2, 2)).trim());

            assertEquals("5", ((String) table.get(0, 3)).trim());
            assertEquals("B:0,3", ((String) table.get(1, 3)).trim());
            assertEquals("B:1,3", ((String) table.get(2, 3)).trim());

            in.close();
        } catch (IOException e) {
            fail(e.getMessage());
        } catch (SheetNotFoundException e) {
            fail(e.getMessage());
        }

    }

    public void testParse2() {
        PoiUtil util = PoiUtil.getPoiUtil();
        InputStream in = getInputStream();
        try {
            BlankDetectionParser parser = new BlankDetectionParser(2, 3);
            Table table = util.getValues(in, "blank", 1, 13, parser);

            assertEquals(4, table.getRowSize());
            assertEquals(3, table.getColumnSize());

            assertEquals("2", ((String) table.get(0, 0)).trim());
            assertEquals("B:0,0", ((String) table.get(1, 0)).trim());
            assertEquals("B:1,0", ((String) table.get(2, 0)).trim());

            assertEquals("3", ((String) table.get(0, 1)).trim());
            assertEquals("B:0,1", ((String) table.get(1, 1)).trim());
            assertEquals("B:1,1", ((String) table.get(2, 1)).trim());

            assertEquals("4", ((String) table.get(0, 2)).trim());
            assertEquals("B:0,2", ((String) table.get(1, 2)).trim());
            assertEquals("B:1,2", ((String) table.get(2, 2)).trim());

            assertEquals("5", ((String) table.get(0, 3)).trim());
            assertEquals("B:0,3", ((String) table.get(1, 3)).trim());
            assertEquals("B:1,3", ((String) table.get(2, 3)).trim());

            in.close();
        } catch (IOException e) {
            fail(e.getMessage());
        } catch (SheetNotFoundException e) {
            fail(e.getMessage());
        }

    }
}
