/*
 * Created on 2004/06/06
 *
 */
package com.muimi.webwiz;

import org.eclipse.jdt.internal.ui.preferences.JavadocConfigurationPropertyPage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * JSF@\ǉEBU[hy[WP
 * @author Shinji Miyamoto
 */
public class SelectImportResourceWizardPage extends WizardPage{

	private ListViewer viewer;
	
	protected SelectImportResourceWizardPage() {
		super("Select Resource");
		setTitle("Select Resource");
		setDescription("Select import resource");
	}

    public void createControl(Composite parent) {
    	
    	WebResourceDesc[] descs = WebtoolsPlugin.getDefault().getWebResourceDescs();
    	
//    	for(int i=0;i<descs.length;i++){
//    		System.out.println(descs[i]);
//    	}
    	JavadocConfigurationPropertyPage p;
    	
    	Composite composite = new Composite(parent, SWT.NONE | SWT.BORDER);
    	composite.setLayout(new FillLayout());
    	
    	viewer = new ListViewer(composite, SWT.SINGLE);
    	viewer.setContentProvider(new WebResourceListContentProvider());
    	viewer.setLabelProvider(new WebResourceListLabelProvider());
    	viewer.setInput(descs);
    	
    	viewer.addSelectionChangedListener(new ISelectionChangedListener(){
			public void selectionChanged(SelectionChangedEvent event) {
				setPageComplete(true);
			}
    	});
    	
        setControl(composite);
    }
    

    class WebResourceListContentProvider implements IStructuredContentProvider{
		public void dispose() {}
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
		public Object[] getElements(Object inputElement) {
			return (Object[])inputElement;
		}
    }
    
    class WebResourceListLabelProvider extends LabelProvider{
    	public String getText(Object element) {
			return ((WebResourceDesc)element).getLabel();
		}
    }
    
    public WebResourceDesc getWebResourceDesc(){
    	return (WebResourceDesc)((IStructuredSelection)viewer.getSelection()).getFirstElement();
    }
    
}
