package com.muimi.webwiz;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;


import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 * 
 * @author Shinji Miyamoto
 */
public class WebtoolsPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static WebtoolsPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;

	/**
	 * The constructor.
	 */
	public WebtoolsPlugin(IPluginDescriptor desc) {
		super(desc);
		plugin = this;
		logInfo("WebtoolsPlugin(desc)");
	}

//	public WebtoolsPlugin() {
//		super();
//		plugin = this;
//		try {
//			resourceBundle = ResourceBundle.getBundle("com.muimi.webwiz.WebtoolsPlugin");
//		} catch (MissingResourceException x) {
//			resourceBundle = null;
//		}
//		logInfo("WebtoolsPlugin()");
//	}

//	/**
//	 * This method is called upon plug-in activation
//	 */
//	public void start(BundleContext context) throws Exception {
//		super.start(context);
//	}
//
//	/**
//	 * This method is called when the plug-in is stopped
//	 */
//	public void stop(BundleContext context) throws Exception {
//		super.stop(context);
//	}	
	
	
	/**
	 * Returns the shared instance.
	 */
	public static WebtoolsPlugin getDefault() {
		return plugin;
	}


	/**
	 * [Jt@CpX擾B
	 * @param path vOC̃CXg[fBNg̑΃pX
	 * @return
	 */
	public String getResourcePath(String path) {
		try {			
			URL baseUrl = getDescriptor().getInstallURL();
			URL resourceUrl = new URL(baseUrl, path);
			String resourcePath = Platform.asLocalURL(resourceUrl).getPath();
			return resourcePath;
		} catch (Exception e) {
			logError("fail to read resource. path=" + path, e);
			return null;
		}
	}


	
	public static void logError(String message, Throwable e){
		IStatus status = new Status(
						Status.ERROR,
						getDefault().getDescriptor().getUniqueIdentifier(),
						0,
						message,
						e
				);
		log(status);
	}
	public static void logInfo(String message){
		IStatus status = new Status(
						Status.INFO,
						getDefault().getDescriptor().getUniqueIdentifier(),
						0,
						message,
						null
				);
		log(status);
	}
	public static void log(IStatus status){
		getDefault().getLog().log(status);
	}

	
	public WebResourceDesc[] getWebResourceDescs(){
		String rootPath = getResourcePath("resource");
		File rootDir = new File(rootPath);
		File[] dirs = rootDir.listFiles(new FileFilter(){
			public boolean accept(File file) {
				return file.isDirectory();
			}
		});
		if(dirs == null){
			return new WebResourceDesc[0];
		}
		WebResourceDesc[] descs = new WebResourceDesc[dirs.length];
		for(int i=0; i<dirs.length; i++){
			File dir = dirs[i];
			File descFile = new File(dir, "desc.xml");
			if(descFile.exists()){
				descs[i] = WebResourceDesc.createByDescFile(dir.getName(), descFile);
			}else{
				descs[i] = WebResourceDesc.createByDescFile(dir.getName());
			}
		}
		return descs;
	}
	
	
	
	/**
	 * Returns the string from the plugin's resource bundle, or 'key' if not
	 * found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = WebtoolsPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}