/**
 * Eclipse Visual Editor Installer <br>
 * Copyright (C) 2001-2005 Tosiki IGA
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package igapyon.eclipse.installer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/**
 * Eclipse Visual Editor ꎮ𓀂CXg[[
 * 
 * @author Tosiki IGA tosiki.iga@nifty.ne.jp
 */
public class EcilpseInstallerTI {
    /**
     * o[Wԍ
     */
    public static final String PRODUCT_VERSION = "2005.03.26";

    /**
     * v_Ng
     */
    public static final String PRODUCT_NAME = "Ecilpse 𓀎xc[ (Visual EditorGfBV)";

    /**
     * 𓀑ΏۂƂȂt@C̈ꗗ
     */
    public static final String[] MODULE_LIST = { "eclipse-SDK-3.0.2-win32.zip",
            "NLpack-eclipse-SDK-3.0.x-win32.zip", "emf-sdo-runtime-3.0.1.zip",
            "GEF-runtime-3.0.1.zip", "VE-runtime-1.0.2.1.zip",
            "NLpack-VE-runtime-1.0.x.zip", "JEM-runtime-1.0.2.1.zip" };

    private CopyThread thread = null;

    private ProgressShowShell progresspanel = null;

    public static final void main(String[] args) {
        try {
            prompt();
            new EcilpseInstallerTI().extractFileAllGui();
        } finally {
            System.exit(0);
        }
    }

    /**
     * prompt product informations.
     */
    public static final void prompt() {
        System.out.println(PRODUCT_NAME + " (" + PRODUCT_VERSION + ")");
        System.out.println("Copyright (C) 2001-2005 Tosiki IGA");
        System.out
                .println("This library is free software, and you are welcome to redistribute it under certain conditions.");
    }

    /**
     * ̃\bh́A܂Ă܂ʁB
     * 
     * @param component
     * @param strJarFileName
     */
    public final void extractFileAllGui() {
        org.eclipse.swt.widgets.Display display = null;
        try {
            display = org.eclipse.swt.widgets.Display.getDefault();
            Shell shell = new Shell(display);

            MessageBox msgbox = new MessageBox(shell, SWT.OK | SWT.CANCEL
                    | SWT.ICON_INFORMATION);
            msgbox.setText(PRODUCT_NAME);
            msgbox.setMessage(PRODUCT_NAME + " (" + PRODUCT_VERSION
                    + ")\n\ñvO Eclipse Visual Editor ꎮ̉𓀂xc[łB\n"
                    + "𓀐tH_I邾ŁAw̃fBNgɈꊇ𓀃CXg[sƂł܂.\n"
                    + "{IɐVKtH_I悤ɂĂ.");
            if (msgbox.open() != SWT.OK) {
                return;
            }

            // TODO ܂t@CȂ_E[hƂɒǉĂقI

            DirectoryDialog dirDialog = new DirectoryDialog(shell);
            dirDialog.setText(PRODUCT_NAME);
            dirDialog
                    .setMessage("Eclipse𓀂𓀐tH_IĂB\nwtH_1KweclipsetH_쐬܂.");
            String selectedDirectory = dirDialog.open();
            if (selectedDirectory == null) {
                MessageBox msgboxCancel = new MessageBox(shell, SWT.OK
                        | SWT.ICON_WARNING);
                msgboxCancel.setText(PRODUCT_NAME);
                msgboxCancel.setMessage("[ȖIɂA𒆒f܂");
                msgboxCancel.open();
                return;
            }

            String targetDirectory = selectedDirectory;
            msgbox = new MessageBox(shell, SWT.OK | SWT.CANCEL
                    | SWT.ICON_QUESTION);
            msgbox.setText(PRODUCT_NAME);
            msgbox.setMessage("tH_ [" + targetDirectory
                    + "] ɑ΂ĉ𓀂s܂B낵łH");
            if (msgbox.open() != SWT.OK) {
                MessageBox msgboxCancel = new MessageBox(shell, SWT.OK
                        | SWT.ICON_WARNING);
                msgboxCancel.setText(PRODUCT_NAME);
                msgboxCancel.setMessage("[ȖIɂA𒆒f܂");
                msgboxCancel.open();
                return;
            }
            try {
                // TODO ̃xŃvOX[^قłB
                System.out.println("ŃvOX[^͐Ă܂.");

                progresspanel = new ProgressShowShell();
                progresspanel.createSShell();

                progresspanel.sShell.open();

                thread = new CopyThread(MODULE_LIST, display, progresspanel,
                        targetDirectory);
                display.asyncExec(thread);
                thread.start();

                while (!progresspanel.sShell.isDisposed()) {
                    if (!display.readAndDispatch())
                        display.sleep();
                }

                if (thread.isSuccessEnd()) {
                    msgbox = new MessageBox(shell, SWT.OK
                            | SWT.ICON_INFORMATION);
                    msgbox.setText(PRODUCT_NAME);
                    msgbox.setMessage("");
                    msgbox.open();
                }
            } catch (Exception ex) {
                MessageBox msgboxError = new MessageBox(shell, SWT.OK
                        | SWT.ICON_ERROR);
                msgboxError.setText(PRODUCT_NAME);
                msgboxError.setMessage("\ʃG[ɂ菈ُ͈I܂\n"
                        + ex.toString());
                msgboxError.open();
                ex.printStackTrace();
            } catch (Error er) {
                MessageBox msgboxError = new MessageBox(shell, SWT.OK
                        | SWT.ICON_ERROR);
                msgboxError.setText(PRODUCT_NAME);
                msgboxError.setMessage("\ʃG[ɂ菈ُ͈I܂\n"
                        + er.toString());
                msgboxError.open();
                er.printStackTrace();
            }
        } finally {
            if (display != null) {
                display.dispose();
            }

        }
    }
}
