/**
 * Eclipse Visual Editor Installer <br>
 * Copyright (C) 2001-2005 Tosiki IGA
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package igapyon.eclipse.installer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/**
 * Eclipse Visual Editor ꎮ𓀂CXg[[
 * 
 * @author Tosiki IGA tosiki.iga@nifty.ne.jp
 */
public class ProgressShowShell {

    org.eclipse.swt.widgets.Shell sShell = null; //  @jve:decl-index=0:visual-constraint="10,10"

    private Text textArchiveFilename = null;

    private Label label = null;

    private Label label1 = null;

    private Label label2 = null;

    private ProgressBar progressBar = null;

    private Text textDirectoryName = null;

    private Text textFileName = null;

    public static void main(String[] args) {
        org.eclipse.swt.widgets.Display display = org.eclipse.swt.widgets.Display
                .getDefault();
        ProgressShowShell thisClass = new ProgressShowShell();
        thisClass.createSShell();
        thisClass.sShell.open();
        while (!thisClass.sShell.isDisposed()) {
            if (!display.readAndDispatch())
                display.sleep();
        }
        display.dispose();
    }

    /**
     * This method initializes sShell
     */
    public void createSShell() {
        sShell = new org.eclipse.swt.widgets.Shell(SWT.APPLICATION_MODAL
                | SWT.DIALOG_TRIM);
        label = new Label(sShell, SWT.NONE);
        label1 = new Label(sShell, SWT.NONE);
        label2 = new Label(sShell, SWT.NONE);
        progressBar = new ProgressBar(sShell, SWT.NONE);
        textArchiveFilename = new Text(sShell, SWT.BORDER);
        textDirectoryName = new Text(sShell, SWT.BORDER);
        textFileName = new Text(sShell, SWT.BORDER);
        sShell.setText("Eclipse Installer TI");
        textArchiveFilename.setBounds(new org.eclipse.swt.graphics.Rectangle(200,15,322,25));
        label
                .setBounds(new org.eclipse.swt.graphics.Rectangle(20, 15, 160,
                        25));
        label.setText("𓀒̃A[JCu");
        label1
                .setBounds(new org.eclipse.swt.graphics.Rectangle(20, 50, 96,
                        25));
        label1.setText("fBNg");
        label2
                .setBounds(new org.eclipse.swt.graphics.Rectangle(20, 90, 94,
                        25));
        label2.setText("t@C");
        progressBar.setBounds(new org.eclipse.swt.graphics.Rectangle(20, 140,
                700, 25));
        textDirectoryName.setBounds(new org.eclipse.swt.graphics.Rectangle(120,
                50, 600, 25));
        textFileName.setBounds(new org.eclipse.swt.graphics.Rectangle(120, 90,
                600, 25));
        textArchiveFilename.setEditable(false);
        textDirectoryName.setEditable(false);
        textFileName.setEditable(false);
        progressBar.setMinimum(0);
        progressBar.setMaximum(100);
        sShell.setSize(new org.eclipse.swt.graphics.Point(776, 253));
    }

    public void setTargetArchiveName(String arg) {
        textArchiveFilename.setText(arg);
    }

    public void setDirectoryName(String arg) {
        textDirectoryName.setText(arg);
    }

    public void setFileName(String arg) {
        textFileName.setText(arg);
    }

    public void setProgress(int arg) {
        progressBar.setSelection(arg);
    }

}
