/*
 * 쐬: 2005/03/26
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
package igapyon.eclipse.installer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

/**
 * @author iga
 * 
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv: EBhE - ݒ - Java - R[hEX^C -
 * R[hEev[g
 */
public class CopyThread extends Thread {
    boolean isSuccessEnd = false;

    String[] MODULE_LIST = null;

    Display display = null;

    ProgressShowShell progresspanel = null;

    String targetDirectory = null;

    public CopyThread(String[] MODULE_LIST, Display display,
            ProgressShowShell progresspanel, String targetDirectory) {
        this.MODULE_LIST = MODULE_LIST;
        this.display = display;
        this.progresspanel = progresspanel;
        this.targetDirectory = targetDirectory;
        this.display.asyncExec(new AsyncExec());
    }

    public boolean isSuccessEnd() {
        return isSuccessEnd;
    }

    class AsyncExec implements Runnable {

        public void run() {
            try {
                // ׂẴt@C𓀂܂B
                for (int index = 0; index < MODULE_LIST.length; index++) {
                    progresspanel.setTargetArchiveName(MODULE_LIST[index]);

                    progresspanel.setDirectoryName("processing file["
                            + MODULE_LIST[index] + "].");
                    extractFileAll(MODULE_LIST[index], targetDirectory);
                }
                isSuccessEnd = true;
            } catch (IOException ex) {
                MessageBox msgboxError = new MessageBox(progresspanel.sShell,
                        SWT.OK | SWT.ICON_ERROR);
                msgboxError.setText(EcilpseInstallerTI.PRODUCT_NAME);
                msgboxError.setMessage("ُ͈I܂\n" + ex.toString());
                msgboxError.open();

                ex.printStackTrace();
            } finally {
                progresspanel.sShell.close();
            }
        }

        /**
         * ^ꂽZIPt@CwfBNgɉ𓀂܂B
         * 
         * @param strJarFileName
         * @param strTargetBaseDirectoryName
         * @throws IOException
         */
        public final void extractFileAll(String strJarFileName,
                String strTargetBaseDirectoryName) throws IOException {
            File fileInputJar = new File(strJarFileName);
            if (fileInputJar.exists() == false) {
                throw new FileNotFoundException("̓t@C["
                        + fileInputJar.getAbsolutePath()
                        + "]܂.𒆒f܂.");
            }

            String strFileSeparator = System.getProperty("file.separator");

            ZipInputStream zipinStream = new ZipInputStream(
                    new BufferedInputStream(new FileInputStream(fileInputJar)));
            for (int iCurrent = 0;; iCurrent++) {
                ZipEntry entry = zipinStream.getNextEntry();
                if (entry == null) {
                    break;
                }

                if (!progresspanel.sShell.isDisposed()) {
                    display.readAndDispatch();
                }

                if (entry.isDirectory()) {
                    String strNewDirectory = strTargetBaseDirectoryName
                            + strFileSeparator + entry.getName();
                    File fileDirectory = new File(strNewDirectory);
                    if (fileDirectory.exists() == false) {
                        System.out.println("new directory:"
                                + fileDirectory.getAbsolutePath());
                        if (fileDirectory.mkdirs() == false) {
                            System.err.println("fail to create new directory:"
                                    + fileDirectory.getAbsolutePath());
                        }
                    }
                    progresspanel.setDirectoryName(fileDirectory
                            .getAbsolutePath());
                } else {
                    String strNewFile = strTargetBaseDirectoryName
                            + strFileSeparator + entry.getName();
                    File fileExtract = new File(strNewFile);
                    if (fileExtract.exists()) {
                        if (fileExtract.canWrite() == false) {
                            System.out.println("can't overwrite exist file:"
                                    + fileExtract.getAbsolutePath());
                            continue;
                        }
                    }
                    System.out.println("Processing file ["
                            + fileExtract.getName() + "]");
                    progresspanel.setProgress(iCurrent);
                    progresspanel.setFileName(fileExtract.getAbsolutePath());
                    if (iCurrent >= 100) {
                        iCurrent = 0;
                    }

                    extractFile(zipinStream, fileExtract, entry.getTime());
                }
            }
        }

        /**
         * ^ꂽ̓Xg[t@Cɏo܂B <br>
         * ȂÃ\bhł̓N[Y͍s܂BZIP̓Xg[̎dlɂ̂łB
         * 
         * @param inStream
         *            ZIP̓Xg[^܂B
         * @param fileExtract
         * @throws FileNotFoundException
         * @throws IOException
         */
        private void extractFile(InputStream inStream, File fileExtract,
                long lastModified) throws FileNotFoundException, IOException {
            OutputStream outStream = null;

            File directory = new File(fileExtract.getAbsoluteFile().getParent());
            if (directory.exists() == false) {
                System.out.println("fBNg [" + directory.getAbsolutePath()
                        + "] ̂ŐVK쐬܂.");
                directory.mkdirs();
            }

            try {
                outStream = new BufferedOutputStream(new FileOutputStream(
                        fileExtract));
                byte[] byteRead = new byte[8192];
                for (;;) {
                    int iReadLen = inStream.read(byteRead);
                    if (iReadLen < 0) {
                        break;
                    }
                    outStream.write(byteRead, 0, iReadLen);
                }
                outStream.flush();
            } finally {
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
            fileExtract.setLastModified(lastModified);
        }
    }
}
