/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.javascript;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.ats.engines.BarsDataSeriesFunction;
import org.eclipsetrader.core.ats.engines.IndicatorFunction;
import org.eclipsetrader.core.charts.NumericDataSeries;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.internal.charts.Util;
import org.eclipsetrader.ui.internal.charts.indicators.Activator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ROC
extends IndicatorFunction {
    private static final long serialVersionUID = -9191442400382251716L;
    private final OHLCField field = OHLCField.Close;
    private int period;

    public ROC() {
    }

    public ROC(BarsDataSeriesFunction bars, int period) {
        super(bars);
        this.period = period;
        this.calculate();
    }

    public static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        BarsDataSeriesFunction bars = (BarsDataSeriesFunction)ScriptableObject.getProperty((Scriptable)ROC.getTopLevelScope((Scriptable)ctorObj), (String)"bars");
        int period = (int)Context.toNumber((Object)args[0]);
        ROC result = new ROC(bars, period);
        return result;
    }

    protected void calculate() {
        Core core;
        int lookback;
        IAdaptable[] values = this.source.getValues();
        if (values.length < (lookback = (core = Activator.getDefault() != null ? Activator.getDefault().getCore() : new Core()).rocLookback(this.period))) {
            this.series = new NumericDataSeries(String.format("%s%d", this.getClassName(), this.period), new Number[0], this.source);
            return;
        }
        int startIdx = 0;
        int endIdx = values.length - 1;
        double[] inReal = Util.getValuesForField(values, this.field);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] outReal = new double[values.length - lookback];
        core.roc(startIdx, endIdx, inReal, this.period, outBegIdx, outNbElement, outReal);
        this.series = new NumericDataSeries(String.format("%s%d", this.getClassName(), this.period), outReal, this.source);
    }

    public Object jsFunction_crosses(IndicatorFunction other, Object bar) {
        return super.jsFunction_crosses(other, bar);
    }

    public Object jsFunction_first() {
        return super.jsFunction_first();
    }

    public Object jsFunction_last() {
        return super.jsFunction_last();
    }

    public Object jsFunction_highest() {
        return super.jsFunction_highest();
    }

    public Object jsFunction_lowest() {
        return super.jsFunction_lowest();
    }
}

