/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.indicators;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumericDataSeries;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.ILineDecorator;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.internal.charts.Util;
import org.eclipsetrader.ui.internal.charts.indicators.Activator;
import org.eclipsetrader.ui.internal.charts.indicators.IGeneralPropertiesAdapter;

public class ADXR
implements IChartObjectFactory,
IGeneralPropertiesAdapter,
ILineDecorator,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private int period = 7;
    private RenderStyle renderStyle = RenderStyle.Line;
    private RGB color;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    @Override
    public RenderStyle getRenderStyle() {
        return this.renderStyle;
    }

    @Override
    public void setRenderStyle(RenderStyle renderStyle) {
        this.renderStyle = renderStyle;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public IChartObject createObject(IDataSeries source) {
        Core core;
        int lookback;
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < (lookback = (core = Activator.getDefault() != null ? Activator.getDefault().getCore() : new Core()).adxrLookback(this.period))) {
            return null;
        }
        int startIdx = 0;
        int endIdx = values.length - 1;
        double[] inHigh = Util.getValuesForField(values, OHLCField.High);
        double[] inLow = Util.getValuesForField(values, OHLCField.Low);
        double[] inClose = Util.getValuesForField(values, OHLCField.Close);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] outReal = new double[values.length - lookback];
        core.adxr(startIdx, endIdx, inHigh, inLow, inClose, this.period, outBegIdx, outNbElement, outReal);
        NumericDataSeries result = new NumericDataSeries(this.getName(), outReal, source);
        return Util.createLineChartObject((IDataSeries)result, this.renderStyle, this.color);
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("period", (Number)this.period);
        parameters.setParameter("style", this.renderStyle.getName());
        if (this.color != null) {
            parameters.setParameter("color", this.color);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.period = parameters.getInteger("period");
        this.renderStyle = parameters.hasParameter("style") ? RenderStyle.getStyleFromName((String)parameters.getString("style")) : RenderStyle.Line;
        this.color = parameters.getColor("color");
    }
}

