/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.indicators;

import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumberValue;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.PixelTools;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.internal.charts.Util;

public class TREND
implements IChartObjectFactory,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private int period = 30;
    private RenderStyle upperLineStyle = RenderStyle.Line;
    private RGB upperLineColor;
    private RenderStyle middleLineStyle = RenderStyle.Dot;
    private RGB middleLineColor;
    private RenderStyle lowerLineStyle = RenderStyle.Line;
    private RGB lowerLineColor;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public RenderStyle getUpperLineStyle() {
        return this.upperLineStyle;
    }

    public void setUpperLineStyle(RenderStyle upperLineStyle) {
        this.upperLineStyle = upperLineStyle;
    }

    public RGB getUpperLineColor() {
        return this.upperLineColor;
    }

    public void setUpperLineColor(RGB upperLineColor) {
        this.upperLineColor = upperLineColor;
    }

    public RenderStyle getMiddleLineStyle() {
        return this.middleLineStyle;
    }

    public void setMiddleLineStyle(RenderStyle middleLineStyle) {
        this.middleLineStyle = middleLineStyle;
    }

    public RGB getMiddleLineColor() {
        return this.middleLineColor;
    }

    public void setMiddleLineColor(RGB middleLineColor) {
        this.middleLineColor = middleLineColor;
    }

    public RenderStyle getLowerLineStyle() {
        return this.lowerLineStyle;
    }

    public void setLowerLineStyle(RenderStyle lowerLineStyle) {
        this.lowerLineStyle = lowerLineStyle;
    }

    public RGB getLowerLineColor() {
        return this.lowerLineColor;
    }

    public void setLowerLineColor(RGB lowerLineColor) {
        this.lowerLineColor = lowerLineColor;
    }

    public IChartObject createObject(IDataSeries source) {
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < this.period) {
            return null;
        }
        double[] inReal = Util.getValuesForField(values, OHLCField.Close);
        int numberPlotPoints = 0;
        double sumxx = 0.0;
        double sumxy = 0.0;
        double sumx = 0.0;
        double sumy = 0.0;
        int i = inReal.length - this.period;
        while (i < inReal.length) {
            double x = numberPlotPoints;
            double y = inReal[i];
            sumx += x;
            sumy += y;
            sumxx += x * x;
            sumxy += x * y;
            ++i;
            ++numberPlotPoints;
        }
        double n = numberPlotPoints;
        double Sxx = sumxx - sumx * sumx / n;
        double Sxy = sumxy - sumx * sumy / n;
        double b = Sxy / Sxx;
        double a = (sumy - b * sumx) / n;
        double average = 0.0;
        numberPlotPoints = 0;
        int i2 = inReal.length - this.period;
        while (i2 < inReal.length) {
            average += Math.pow(inReal[i2] - (a + (double)numberPlotPoints * b), 2.0);
            ++i2;
            ++numberPlotPoints;
        }
        average /= (double)numberPlotPoints;
        average /= Math.sqrt(average);
        Date d1 = (Date)values[values.length - this.period].getAdapter(Date.class);
        Date d2 = (Date)values[values.length - 1].getAdapter(Date.class);
        GroupChartObject object = new GroupChartObject();
        object.add((IChartObject)new LineToolObject(this.middleLineStyle, this.middleLineColor, d1, a, d2, a + (double)this.period * b));
        object.add((IChartObject)new LineToolObject(this.upperLineStyle, this.upperLineColor, d1, a + average, d2, a + average + (double)this.period * b));
        object.add((IChartObject)new LineToolObject(this.lowerLineStyle, this.lowerLineColor, d1, a - average, d2, a - average + (double)this.period * b));
        return object;
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("period", (Number)this.period);
        parameters.setParameter("upper-line-style", this.upperLineStyle.getName());
        if (this.upperLineColor != null) {
            parameters.setParameter("upper-line-color", this.upperLineColor);
        }
        parameters.setParameter("middle-line-style", this.middleLineStyle.getName());
        if (this.middleLineColor != null) {
            parameters.setParameter("middle-line-color", this.middleLineColor);
        }
        parameters.setParameter("lower-line-style", this.lowerLineStyle.getName());
        if (this.lowerLineColor != null) {
            parameters.setParameter("lower-line-color", this.lowerLineColor);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.period = parameters.getInteger("period");
        this.upperLineStyle = parameters.hasParameter("upper-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("upper-line-style")) : RenderStyle.Line;
        this.upperLineColor = parameters.getColor("upper-line-color");
        this.middleLineStyle = parameters.hasParameter("middle-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("middle-line-style")) : RenderStyle.Dot;
        this.middleLineColor = parameters.getColor("middle-line-color");
        this.lowerLineStyle = parameters.hasParameter("lower-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("lower-line-style")) : RenderStyle.Line;
        this.lowerLineColor = parameters.getColor("lower-line-color");
    }

    private class LineToolObject
    implements IChartObject {
        private RenderStyle style;
        private RGB color;
        private Date d1;
        private Date d2;
        private Double v1;
        private Double v2;
        private Point p1;
        private Point p2;
        private boolean hasFocus;

        public LineToolObject(RenderStyle style, RGB color, Date d1, Double v1, Date d2, Double v2) {
            this.style = style;
            this.color = color;
            this.d1 = d1;
            this.v1 = v1;
            this.d2 = d2;
            this.v2 = v2;
        }

        public void setDataBounds(DataBounds bounds) {
        }

        public IDataSeries getDataSeries() {
            return new DataSeries(TREND.this.name, new IAdaptable[]{new NumberValue(this.d1, (Number)this.v1), new NumberValue(this.d2, (Number)this.v2)});
        }

        public boolean containsPoint(int x, int y) {
            if (this.p1 != null && this.p2 != null) {
                return PixelTools.isPointOnLine((int)x, (int)y, (int)this.p1.x, (int)this.p1.y, (int)this.p2.x, (int)this.p2.y);
            }
            return false;
        }

        public String getToolTip() {
            return TREND.this.name;
        }

        public String getToolTip(int x, int y) {
            return null;
        }

        public void handleFocusGained(ChartObjectFocusEvent event) {
            this.hasFocus = true;
        }

        public void handleFocusLost(ChartObjectFocusEvent event) {
            this.hasFocus = false;
        }

        public void invalidate() {
        }

        public void paint(IGraphics graphics) {
            this.p1 = new Point(graphics.mapToHorizontalAxis((Object)this.d1), graphics.mapToVerticalAxis((Object)this.v1));
            this.p2 = new Point(graphics.mapToHorizontalAxis((Object)this.d2), graphics.mapToVerticalAxis((Object)this.v2));
            graphics.pushState();
            switch (this.style) {
                case Dash: {
                    graphics.setLineStyle(2);
                    break;
                }
                case Dot: {
                    graphics.setLineStyle(3);
                    break;
                }
                default: {
                    graphics.setLineStyle(1);
                }
            }
            graphics.setForegroundColor(this.color);
            graphics.setLineWidth(this.hasFocus ? 2 : 0);
            graphics.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
            graphics.popState();
        }

        public void paintScale(Graphics graphics) {
        }

        public void accept(IChartObjectVisitor visitor) {
        }
    }
}

