/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.patterns;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.ILineDecorator;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.charts.patterns.Messages;
import org.eclipsetrader.ui.internal.charts.PatternBox;
import org.eclipsetrader.ui.internal.charts.indicators.IGeneralPropertiesAdapter;

public class GAP
implements IChartObjectFactory,
IGeneralPropertiesAdapter,
ILineDecorator,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private RenderStyle renderStyle = RenderStyle.Line;
    private RGB color;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RenderStyle getRenderStyle() {
        return this.renderStyle;
    }

    @Override
    public void setRenderStyle(RenderStyle renderStyle) {
        this.renderStyle = renderStyle;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public IChartObject createObject(IDataSeries source) {
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < 3) {
            return null;
        }
        GroupChartObject object = new GroupChartObject();
        int i = values.length - 3;
        while (i >= 0) {
            IOHLC[] outBars;
            IOHLC rec0 = (IOHLC)values[i].getAdapter(IOHLC.class);
            IOHLC rec1 = (IOHLC)values[i + 1].getAdapter(IOHLC.class);
            IOHLC rec2 = (IOHLC)values[i + 2].getAdapter(IOHLC.class);
            if (rec0.getHigh() < rec1.getLow() && this.closesInTopQuarter(rec1) && this.closesInTopQuarter(rec2)) {
                outBars = new IOHLC[]{rec0, rec1, rec2};
                object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), Messages.Bullish));
                i -= outBars.length;
            } else if (rec1.getHigh() < rec0.getLow() && this.closesInBottomQuarter(rec1) && this.closesInBottomQuarter(rec2)) {
                outBars = new IOHLC[]{rec0, rec1, rec2};
                object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), Messages.Bearish));
                i -= outBars.length;
            }
            --i;
        }
        return object;
    }

    private boolean closesInTopQuarter(IOHLC rec) {
        return rec.getClose() >= rec.getLow() + (rec.getHigh() - rec.getLow()) * 3.0 / 4.0;
    }

    private boolean closesInBottomQuarter(IOHLC rec) {
        return rec.getClose() <= rec.getLow() + (rec.getHigh() - rec.getLow()) / 4.0;
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("style", this.renderStyle.getName());
        if (this.color != null) {
            parameters.setParameter("color", this.color);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.renderStyle = parameters.hasParameter("style") ? RenderStyle.getStyleFromName((String)parameters.getString("style")) : RenderStyle.Line;
        this.color = parameters.getColor("color");
    }
}

