/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.patterns;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.ILineDecorator;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.charts.patterns.Messages;
import org.eclipsetrader.ui.internal.charts.PatternBox;
import org.eclipsetrader.ui.internal.charts.indicators.IGeneralPropertiesAdapter;

public class LindhalSell
implements IChartObjectFactory,
IGeneralPropertiesAdapter,
ILineDecorator,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private RenderStyle renderStyle = RenderStyle.Line;
    private RGB color;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RenderStyle getRenderStyle() {
        return this.renderStyle;
    }

    @Override
    public void setRenderStyle(RenderStyle renderStyle) {
        this.renderStyle = renderStyle;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public IChartObject createObject(IDataSeries source) {
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < 9) {
            return null;
        }
        GroupChartObject object = new GroupChartObject();
        int i = values.length - 9;
        while (i >= 0) {
            IOHLC[] outBars = new IOHLC[]{(IOHLC)values[i].getAdapter(IOHLC.class), (IOHLC)values[i + 1].getAdapter(IOHLC.class), (IOHLC)values[i + 2].getAdapter(IOHLC.class), (IOHLC)values[i + 3].getAdapter(IOHLC.class), (IOHLC)values[i + 4].getAdapter(IOHLC.class), (IOHLC)values[i + 5].getAdapter(IOHLC.class), (IOHLC)values[i + 6].getAdapter(IOHLC.class), (IOHLC)values[i + 7].getAdapter(IOHLC.class), (IOHLC)values[i + 8].getAdapter(IOHLC.class)};
            int sentiment = this.getSentiment(outBars);
            if (sentiment > 0) {
                object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), Messages.Bullish));
                i -= outBars.length;
            } else if (sentiment < 0) {
                object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), Messages.Bearish));
                i -= outBars.length;
            }
            --i;
        }
        return object;
    }

    int getSentiment(IOHLC[] recs) {
        int a = 0;
        int b = 1;
        int d = 1;
        int e = 1;
        double ahigh = recs[a].getHigh();
        int size = Math.min(8, recs.length);
        while (b < size) {
            if (recs[a].getLow() > recs[b].getLow() && recs[b].getHigh() < ahigh) break;
            ++b;
        }
        d = b + 1;
        while (d < size) {
            if (recs[d].getHigh() < ahigh && recs[d - 1].getHigh() < ahigh && recs[d - 1].getHigh() < recs[d].getHigh()) break;
            ++d;
        }
        e = d + 1;
        while (e < size) {
            IOHLC rece = recs[e];
            IOHLC recf = recs[e - 1];
            if (rece.getLow() < recf.getLow() && rece.getClose() < recf.getClose() && rece.getClose() < rece.getOpen() && rece.getHigh() < ahigh && recf.getHigh() < ahigh) {
                return -1;
            }
            ++e;
        }
        return 0;
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("style", this.renderStyle.getName());
        if (this.color != null) {
            parameters.setParameter("color", this.color);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.renderStyle = parameters.hasParameter("style") ? RenderStyle.getStyleFromName((String)parameters.getString("style")) : RenderStyle.Line;
        this.color = parameters.getColor("color");
    }
}

