/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.ChartObject;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.IGraphics;

public class PatternBox
extends ChartObject {
    IOHLC[] bars;
    RGB color;
    String title;
    String label;
    double highest = Double.MIN_VALUE;
    double lowest = Double.MAX_VALUE;
    int x1;
    int x2;
    int y1;
    int y2;
    Rectangle r1;
    Rectangle r2;
    boolean selected;

    public PatternBox(IOHLC[] bars, RGB color, String title, String label) {
        this.bars = bars;
        this.color = color;
        this.title = title;
        this.label = label;
        int i = 0;
        while (i < bars.length) {
            this.highest = Math.max(this.highest, bars[i].getHigh());
            this.lowest = Math.min(this.lowest, bars[i].getLow());
            ++i;
        }
    }

    public void paint(IGraphics graphics) {
        this.x1 = graphics.mapToHorizontalAxis((Object)this.bars[0].getDate());
        this.x2 = graphics.mapToHorizontalAxis((Object)this.bars[this.bars.length - 1].getDate());
        this.y1 = graphics.mapToVerticalAxis((Object)this.highest) - 10;
        this.y2 = graphics.mapToVerticalAxis((Object)this.lowest) + 10;
        graphics.setForegroundColor(this.color);
        Font oldFont = graphics.getFont();
        Font font = null;
        if (this.selected) {
            graphics.setLineWidth(2);
            FontData fontData = oldFont.getFontData()[0];
            font = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
            graphics.setFont(font);
        }
        Point e1 = graphics.stringExtent(this.title);
        Point e2 = graphics.stringExtent(this.label);
        this.r1 = new Rectangle(this.x1, this.y1 - e1.y - e2.y, e1.x, e1.y);
        graphics.drawString(this.title, this.x1, this.y1 - e1.y - e2.y);
        this.r2 = new Rectangle(this.x1, this.y1 - e2.y, e2.x, e2.y);
        graphics.drawString(this.label, this.x1, this.y1 - e2.y);
        graphics.drawLine(this.x1, this.y1, this.x2, this.y1);
        graphics.drawLine(this.x1, this.y1, this.x1, this.y1 + 5);
        graphics.drawLine(this.x2, this.y1, this.x2, this.y1 + 5);
        graphics.drawLine(this.x1, this.y2, this.x1, this.y2 - 5);
        graphics.drawLine(this.x2, this.y2, this.x2, this.y2 - 5);
        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
        if (font != null) {
            graphics.setFont(oldFont);
            font.dispose();
        }
    }

    public void handleFocusGained(ChartObjectFocusEvent event) {
        this.selected = true;
    }

    public void handleFocusLost(ChartObjectFocusEvent event) {
        this.selected = false;
    }

    public boolean containsPoint(int x, int y) {
        if (x >= this.x1 && x <= this.x2 && (Math.abs(y - this.y1) <= 2 || Math.abs(y - this.y2) <= 2)) {
            return true;
        }
        if (x >= this.r1.x && x < this.r1.x + this.r1.width && y >= this.r1.y && y < this.r1.y + this.r1.height) {
            return true;
        }
        return x >= this.r2.x && x < this.r2.x + this.r2.width && y >= this.r2.y && y < this.r2.y + this.r2.height;
    }
}

