/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.charts.indicators.MACD;
import org.eclipsetrader.ui.internal.charts.MATypeInput;
import org.eclipsetrader.ui.internal.charts.OHLCFieldInput;
import org.eclipsetrader.ui.internal.charts.RenderStyleInput;
import org.eclipsetrader.ui.internal.charts.indicators.Messages;

public class MACDPropertiesPage
extends PropertyPage {
    private OHLCFieldInput input;
    private Spinner fastPeriod;
    private Spinner slowPeriod;
    private Spinner signalPeriod;
    private MATypeInput fastMaType;
    private MATypeInput slowMaType;
    private MATypeInput signalMaType;
    private RenderStyleInput macdLineStyle;
    private RenderStyleInput signalLineStyle;
    private RenderStyleInput histLineStyle;

    public MACDPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.MAConvergenceDivergence);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        label.setText(Messages.InputField);
        this.input = new OHLCFieldInput(content);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        label = new Label(content, 0);
        label.setText(Messages.FastPeriod);
        this.fastPeriod = new Spinner(content, 2048);
        this.fastPeriod.setValues(7, 1, 9999, 0, 1, 5);
        label = new Label(content, 0);
        label.setText(Messages.FastMAType);
        this.fastMaType = new MATypeInput(content);
        label = new Label(content, 0);
        label.setText(Messages.SlowPeriod);
        this.slowPeriod = new Spinner(content, 2048);
        this.slowPeriod.setValues(21, 1, 9999, 0, 1, 5);
        label = new Label(content, 0);
        label.setText(Messages.SlowMAType);
        this.slowMaType = new MATypeInput(content);
        label = new Label(content, 0);
        label.setText(Messages.SignalPeriod);
        this.signalPeriod = new Spinner(content, 2048);
        this.signalPeriod.setValues(14, 1, 9999, 0, 1, 5);
        label = new Label(content, 0);
        label.setText(Messages.SignalMAType);
        this.signalMaType = new MATypeInput(content);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        label = new Label(content, 0);
        label.setText(Messages.MACDLineStyle);
        this.macdLineStyle = new RenderStyleInput(content);
        label = new Label(content, 0);
        label.setText(Messages.SignalLineStyle);
        this.signalLineStyle = new RenderStyleInput(content);
        label = new Label(content, 0);
        label.setText(Messages.HisteresisLineStyle);
        this.histLineStyle = new RenderStyleInput(content);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        MACD object = (MACD)this.getElement().getAdapter(MACD.class);
        this.input.setSelection(object.getField());
        this.fastPeriod.setSelection(object.getFastPeriod());
        this.fastMaType.setSelection(object.getFastMaType());
        this.slowPeriod.setSelection(object.getSlowPeriod());
        this.slowMaType.setSelection(object.getSlowMaType());
        this.signalPeriod.setSelection(object.getSignalPeriod());
        this.signalMaType.setSelection(object.getSignalMaType());
        this.macdLineStyle.setSelection(object.getMacdLineStyle());
        this.signalLineStyle.setSelection(object.getSignalLineStyle());
        this.histLineStyle.setSelection(object.getHistLineStyle());
        super.performDefaults();
    }

    public boolean performOk() {
        MACD object = (MACD)this.getElement().getAdapter(MACD.class);
        object.setField(this.input.getSelection());
        object.setFastPeriod(this.fastPeriod.getSelection());
        object.setFastMaType(this.fastMaType.getSelection());
        object.setSlowPeriod(this.slowPeriod.getSelection());
        object.setSlowMaType(this.slowMaType.getSelection());
        object.setSignalPeriod(this.signalPeriod.getSelection());
        object.setSignalMaType(this.signalMaType.getSelection());
        object.setMacdLineStyle(this.macdLineStyle.getSelection());
        object.setSignalLineStyle(this.signalLineStyle.getSelection());
        object.setHistLineStyle(this.histLineStyle.getSelection());
        return super.performOk();
    }
}

