/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.charts.indicators.STOCHRSI;
import org.eclipsetrader.ui.internal.charts.indicators.Messages;

public class STOCHRSIGeneralPropertiesPage
extends PropertyPage {
    private Text text;
    private Button override;
    private ColorSelector kLineColor;
    private ColorSelector dLineColor;

    public STOCHRSIGeneralPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.General);
        Label label = new Label(content, 0);
        label.setText(Messages.Label);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        this.text = new Text(content, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        this.override = new Button(content, 32);
        this.override.setText(Messages.OverrideColorTheme);
        this.override.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                STOCHRSIGeneralPropertiesPage.this.updateControlsEnablement();
            }
        });
        label = new Label(content, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.KLineColor);
        this.kLineColor = new ColorSelector(content);
        this.kLineColor.setColorValue(new RGB(0, 0, 255));
        this.kLineColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText(Messages.DLineColor);
        this.dLineColor = new ColorSelector(content);
        this.dLineColor.setColorValue(new RGB(0, 0, 255));
        this.dLineColor.getButton().setData("label", (Object)label);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        STOCHRSI object = (STOCHRSI)this.getElement().getAdapter(STOCHRSI.class);
        this.text.setText(object.getName());
        this.override.setSelection(object.getKLineColor() != null || object.getDLineColor() != null);
        if (object.getKLineColor() != null) {
            this.kLineColor.setColorValue(object.getKLineColor());
        }
        if (object.getDLineColor() != null) {
            this.dLineColor.setColorValue(object.getDLineColor());
        }
        this.updateControlsEnablement();
        super.performDefaults();
    }

    public boolean performOk() {
        STOCHRSI object = (STOCHRSI)this.getElement().getAdapter(STOCHRSI.class);
        object.setName(this.text.getText());
        object.setKLineColor(this.override.getSelection() ? this.kLineColor.getColorValue() : null);
        object.setDLineColor(this.override.getSelection() ? this.dLineColor.getColorValue() : null);
        return super.performOk();
    }

    protected void updateControlsEnablement() {
        this.kLineColor.setEnabled(this.override.getSelection());
        ((Label)this.kLineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        this.dLineColor.setEnabled(this.override.getSelection());
        ((Label)this.dLineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
    }
}

