/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.repository.local.Messages;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.IdentifiersCollection;
import org.eclipsetrader.repository.local.internal.ScriptsCollection;
import org.eclipsetrader.repository.local.internal.SecurityCollection;
import org.eclipsetrader.repository.local.internal.StrategiesCollection;
import org.eclipsetrader.repository.local.internal.TradeCollection;
import org.eclipsetrader.repository.local.internal.WatchListCollection;
import org.eclipsetrader.repository.local.internal.stores.RepositoryStore;

public class LocalRepository
implements IRepository,
ISchedulingRule {
    public static final String URI_SCHEMA = "local";
    public static final String URI_SECURITY_PART = "securities";
    public static final String URI_SECURITY_HISTORY_PART = "securities/history";
    public static final String URI_SECURITY_INTRADAY_HISTORY_PART = "securities/history/{0}/{1}";
    public static final String URI_WATCHLIST_PART = "watchlists";
    public static final String URI_TRADE_PART = "trades";
    public static final String URI_SCRIPT_PART = "scripts";
    public static final String URI_STRATEGY_PART = "strategies";
    public static final String IDENTIFIERS_FILE = "identifiers.xml";
    public static final String SECURITIES_FILE = "securities.xml";
    public static final String SECURITIES_HISTORY_FILE = ".history";
    public static final String WATCHLISTS_FILE = "watchlists.xml";
    public static final String TRADES_FILE = "trades.xml";
    public static final String SCRIPTS_FILE = "scripts.xml";
    public static final String STRATEGIES_FILE = "strategies.xml";
    private static LocalRepository instance;
    private IPath location;
    private IdentifiersCollection identifiers;
    private SecurityCollection securities;
    private WatchListCollection watchlists;
    private TradeCollection trades;
    private ScriptsCollection scripts;
    private StrategiesCollection strategies;
    private IJobManager jobManager;
    private final ILock lock;

    public LocalRepository(IPath location) {
        this.location = location;
        instance = this;
        this.jobManager = Job.getJobManager();
        this.lock = this.jobManager.newLock();
        this.identifiers = new IdentifiersCollection();
        this.securities = new SecurityCollection();
        this.scripts = new ScriptsCollection();
    }

    public static LocalRepository getInstance() {
        return instance;
    }

    public IPath getLocation() {
        return this.location;
    }

    public void startUp() {
        File file = this.location.append(IDENTIFIERS_FILE).toFile();
        this.identifiers = (IdentifiersCollection)this.unmarshal(IdentifiersCollection.class, file);
        if (this.identifiers == null) {
            this.identifiers = new IdentifiersCollection();
        }
        file = this.location.append(SECURITIES_FILE).toFile();
        this.securities = (SecurityCollection)this.unmarshal(SecurityCollection.class, file);
        if (this.securities == null) {
            this.securities = new SecurityCollection();
        }
        file = this.location.append(SCRIPTS_FILE).toFile();
        this.scripts = (ScriptsCollection)this.unmarshal(ScriptsCollection.class, file);
        if (this.scripts == null) {
            this.scripts = new ScriptsCollection();
        }
    }

    protected synchronized void initializeWatchListsCollections() {
        if (this.watchlists == null) {
            if (Activator.getDefault() != null) {
                File file = Activator.getDefault().getStateLocation().append(WATCHLISTS_FILE).toFile();
                this.watchlists = (WatchListCollection)this.unmarshal(WatchListCollection.class, file);
            }
            if (this.watchlists == null) {
                this.watchlists = WatchListCollection.getInstance();
                if (this.watchlists == null) {
                    this.watchlists = new WatchListCollection();
                }
            }
        }
    }

    protected synchronized void initializeStrategiesListsCollections() {
        if (this.strategies == null) {
            if (Activator.getDefault() != null) {
                File file = Activator.getDefault().getStateLocation().append(STRATEGIES_FILE).toFile();
                this.strategies = (StrategiesCollection)this.unmarshal(StrategiesCollection.class, file);
            }
            if (this.strategies == null) {
                this.strategies = StrategiesCollection.getInstance();
                if (this.strategies == null) {
                    this.strategies = new StrategiesCollection();
                }
            }
        }
    }

    protected synchronized void initializeTradesCollections() {
        if (this.trades == null) {
            if (Activator.getDefault() != null) {
                File file = Activator.getDefault().getStateLocation().append(TRADES_FILE).toFile();
                this.trades = (TradeCollection)this.unmarshal(TradeCollection.class, file);
            }
            if (this.trades == null) {
                this.trades = TradeCollection.getInstance();
                if (this.trades == null) {
                    this.trades = new TradeCollection();
                }
            }
        }
    }

    public void shutDown() {
        File file;
        if (this.watchlists != null) {
            file = this.location.append(WATCHLISTS_FILE).toFile();
            this.marshal(this.watchlists, WatchListCollection.class, file);
        }
        file = this.location.append(SECURITIES_FILE).toFile();
        this.marshal(this.securities, SecurityCollection.class, file);
        file = this.location.append(IDENTIFIERS_FILE).toFile();
        this.marshal(this.identifiers, IdentifiersCollection.class, file);
        file = this.location.append(SCRIPTS_FILE).toFile();
        this.marshal(this.scripts, ScriptsCollection.class, file);
        if (this.strategies != null) {
            file = this.location.append(STRATEGIES_FILE).toFile();
            this.marshal(this.strategies, StrategiesCollection.class, file);
        }
        if (this.trades != null) {
            file = this.location.append(TRADES_FILE).toFile();
            this.marshal(this.trades, TradeCollection.class, file);
        }
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IStore createObject() {
        return new RepositoryStore();
    }

    public IStore[] fetchObjects(IProgressMonitor monitor) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.securities.getList());
        list.addAll(this.scripts.getList());
        if (this.strategies == null) {
            this.initializeStrategiesListsCollections();
        }
        list.addAll(this.strategies.getList());
        if (this.watchlists == null) {
            this.initializeWatchListsCollections();
        }
        list.addAll(this.watchlists.getList());
        if (this.trades == null) {
            this.initializeTradesCollections();
        }
        list.addAll(this.trades.getList());
        return list.toArray(new IStore[list.size()]);
    }

    public IStore getObject(URI uri) {
        if (URI_SECURITY_PART.equals(uri.getSchemeSpecificPart())) {
            return this.securities.get(uri);
        }
        if (URI_WATCHLIST_PART.equals(uri.getSchemeSpecificPart())) {
            if (this.watchlists == null) {
                this.initializeWatchListsCollections();
            }
            return this.watchlists.get(uri);
        }
        if (URI_TRADE_PART.equals(uri.getSchemeSpecificPart())) {
            if (this.trades == null) {
                this.initializeTradesCollections();
            }
            return this.trades.get(uri);
        }
        if (URI_SCRIPT_PART.equals(uri.getSchemeSpecificPart())) {
            return this.scripts.get(uri);
        }
        if (URI_STRATEGY_PART.equals(uri.getSchemeSpecificPart())) {
            if (this.strategies == null) {
                this.initializeStrategiesListsCollections();
            }
            return this.strategies.get(uri);
        }
        return null;
    }

    public IStatus runInRepository(IRepositoryRunnable runnable, IProgressMonitor monitor) {
        return this.runInRepository(runnable, this, monitor);
    }

    public IStatus runInRepository(IRepositoryRunnable runnable, ISchedulingRule rule, IProgressMonitor monitor) {
        IStatus status;
        this.jobManager.beginRule(rule, monitor);
        try {
            try {
                this.lock.acquire();
                try {
                    status = runnable.run(monitor);
                }
                catch (Exception e) {
                    status = new Status(4, "org.eclipsetrader.repository.local", 0, "Error running repository task", (Throwable)e);
                    Activator.getDefault().getLog().log(status);
                }
                catch (LinkageError e) {
                    status = new Status(4, "org.eclipsetrader.repository.local", 0, "Error running repository task", (Throwable)e);
                    Activator.getDefault().getLog().log(status);
                }
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.repository.local", 0, "Error running repository task", (Throwable)e);
                Activator.getDefault().getLog().log(status);
                this.lock.release();
                this.jobManager.endRule(rule);
            }
        }
        finally {
            this.lock.release();
            this.jobManager.endRule(rule);
        }
        return status;
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this == rule;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    protected void marshal(Object object, Class clazz, File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error validating XML: " + event.getMessage(), null);
                    Activator.getDefault().getLog().log((IStatus)status);
                    return true;
                }
            });
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
            marshaller.marshal(object, (Writer)new FileWriter(file));
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error saving securities", null);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected Object unmarshal(Class clazz, File file) {
        try {
            if (file.exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error validating XML: " + event.getMessage(), null);
                        Activator.getDefault().getLog().log((IStatus)status);
                        return true;
                    }
                });
                return unmarshaller.unmarshal(file);
            }
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error loading identifiers", null);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return null;
    }

    public String getSchema() {
        return URI_SCHEMA;
    }

    public int hashCode() {
        return 3 * URI_SCHEMA.hashCode();
    }

    public String toString() {
        return Messages.LocalRepository_Local;
    }
}

