/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.repository.local.internal.types.IdentifierType;

@XmlRootElement(name="list")
public class IdentifiersCollection {
    private static IdentifiersCollection instance;
    @XmlElementRef
    private TreeSet<IdentifierType> list;
    private Map<String, IFeedIdentifier> identifierMap;

    public IdentifiersCollection() {
        instance = this;
        this.list = new TreeSet();
    }

    public static IdentifiersCollection getInstance() {
        if (instance == null) {
            instance = new IdentifiersCollection();
        }
        return instance;
    }

    public IFeedIdentifier getFeedIdentifierFromSymbol(String symbol) {
        IFeedIdentifier feedIdentifier;
        if (this.identifierMap == null) {
            this.identifierMap = new HashMap<String, IFeedIdentifier>();
            for (IdentifierType type : this.list) {
                this.identifierMap.put(type.getSymbol(), type.getIdentifier());
            }
        }
        if ((feedIdentifier = this.identifierMap.get(symbol)) == null) {
            IdentifierType identifierType = new IdentifierType(symbol);
            feedIdentifier = identifierType.getIdentifier();
            this.list.add(identifierType);
            this.identifierMap.put(symbol, feedIdentifier);
        }
        return feedIdentifier;
    }

    public void putFeedIdentifier(IFeedIdentifier feedIdentifier) {
        Iterator<IdentifierType> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getSymbol().equals(feedIdentifier.getSymbol())) continue;
            iter.remove();
        }
        IdentifierType identifierType = new IdentifierType(feedIdentifier);
        this.list.add(identifierType);
        if (this.identifierMap != null) {
            this.identifierMap.put(feedIdentifier.getSymbol(), feedIdentifier);
        }
    }

    public TreeSet<IdentifierType> getList() {
        return this.list;
    }
}

