/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipsetrader.repository.local.internal.stores.SecurityStore;

@XmlRootElement(name="list")
public class SecurityCollection {
    private static SecurityCollection instance;
    @XmlAttribute(name="next_id")
    private Integer nextId = new Integer(1);
    @XmlElementRef
    private List<SecurityStore> list;
    private Map<URI, SecurityStore> uriMap;

    public SecurityCollection() {
        instance = this;
        this.list = new ArrayList<SecurityStore>();
    }

    public static SecurityCollection getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityStore get(URI uri) {
        SecurityCollection securityCollection = this;
        synchronized (securityCollection) {
            if (this.uriMap == null) {
                this.uriMap = new HashMap<URI, SecurityStore>();
                for (SecurityStore securityStore : this.list) {
                    this.uriMap.put(securityStore.toURI(), securityStore);
                }
            }
        }
        return this.uriMap.get(uri);
    }

    public SecurityStore create() {
        SecurityStore securityStore = new SecurityStore(this.nextId);
        this.list.add(securityStore);
        if (this.uriMap != null) {
            this.uriMap.put(securityStore.toURI(), securityStore);
        }
        this.nextId = new Integer(this.nextId + 1);
        return securityStore;
    }

    public void delete(SecurityStore securityStore) {
        Iterator<SecurityStore> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next() != securityStore) continue;
            iter.remove();
            if (this.uriMap == null) break;
            this.uriMap.remove(securityStore.toURI());
            break;
        }
    }

    public SecurityStore[] getAll() {
        return this.list.toArray(new SecurityStore[this.list.size()]);
    }

    public List<SecurityStore> getList() {
        return this.list;
    }

    public SecurityStore[] toArray() {
        return this.list.toArray(new SecurityStore[this.list.size()]);
    }
}

