/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipsetrader.repository.local.internal.stores.StrategyScriptStore;

@XmlRootElement(name="list")
public class StrategiesCollection {
    private static StrategiesCollection instance;
    @XmlAttribute(name="next_id")
    private Integer nextId = new Integer(1);
    @XmlElementRef
    private List<StrategyScriptStore> list;
    private Map<URI, StrategyScriptStore> uriMap;

    public StrategiesCollection() {
        instance = this;
        this.list = new ArrayList<StrategyScriptStore>();
    }

    public static StrategiesCollection getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StrategyScriptStore get(URI uri) {
        StrategiesCollection strategiesCollection = this;
        synchronized (strategiesCollection) {
            if (this.uriMap == null) {
                this.uriMap = new HashMap<URI, StrategyScriptStore>();
                for (StrategyScriptStore store : this.list) {
                    this.uriMap.put(store.toURI(), store);
                }
            }
        }
        return this.uriMap.get(uri);
    }

    public StrategyScriptStore create() {
        StrategyScriptStore securityStore = new StrategyScriptStore(this.nextId);
        this.list.add(securityStore);
        if (this.uriMap != null) {
            this.uriMap.put(securityStore.toURI(), securityStore);
        }
        this.nextId = new Integer(this.nextId + 1);
        return securityStore;
    }

    public void delete(StrategyScriptStore tradeStore) {
        Iterator<StrategyScriptStore> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next() != tradeStore) continue;
            iter.remove();
            if (this.uriMap == null) break;
            this.uriMap.remove(tradeStore.toURI());
            break;
        }
    }

    public StrategyScriptStore[] getAll() {
        return this.list.toArray(new StrategyScriptStore[this.list.size()]);
    }

    public List<StrategyScriptStore> getList() {
        return this.list;
    }

    public StrategyScriptStore[] toArray() {
        return this.list.toArray(new StrategyScriptStore[this.list.size()]);
    }
}

