/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipsetrader.repository.local.internal.stores.WatchListStore;

@XmlRootElement(name="list")
public class WatchListCollection {
    private static WatchListCollection instance;
    @XmlAttribute(name="next_id")
    private Integer nextId = new Integer(1);
    @XmlElementRef
    private List<WatchListStore> list;
    private Map<URI, WatchListStore> uriMap;

    public WatchListCollection() {
        instance = this;
        this.list = new ArrayList<WatchListStore>();
    }

    public static WatchListCollection getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchListStore get(URI uri) {
        WatchListCollection watchListCollection = this;
        synchronized (watchListCollection) {
            if (this.uriMap == null) {
                this.uriMap = new HashMap<URI, WatchListStore>();
                for (WatchListStore securityStore : this.list) {
                    this.uriMap.put(securityStore.toURI(), securityStore);
                }
            }
        }
        return this.uriMap.get(uri);
    }

    public WatchListStore create() {
        WatchListStore securityStore = new WatchListStore(this.nextId);
        this.list.add(securityStore);
        if (this.uriMap != null) {
            this.uriMap.put(securityStore.toURI(), securityStore);
        }
        this.nextId = new Integer(this.nextId + 1);
        return securityStore;
    }

    public void delete(WatchListStore securityStore) {
        Iterator<WatchListStore> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next() != securityStore) continue;
            iter.remove();
            if (this.uriMap == null) break;
            this.uriMap.remove(securityStore.toURI());
            break;
        }
    }

    public WatchListStore[] getAll() {
        return this.list.toArray(new WatchListStore[this.list.size()]);
    }

    public List<WatchListStore> getList() {
        return this.list;
    }

    public WatchListStore[] toArray() {
        return this.list.toArray(new WatchListStore[this.list.size()]);
    }
}

