/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.repository.local.LocalRepository;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.stores.IntradayHistoryStore;
import org.eclipsetrader.repository.local.internal.stores.LazyStoreProperties;
import org.eclipsetrader.repository.local.internal.types.HistoryType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HistoryStore
implements IStore {
    private Integer id;
    private ISecurity security;
    private Map<String, WeakReference<IntradayHistoryStore>> intradayStores = new HashMap<String, WeakReference<IntradayHistoryStore>>();

    public HistoryStore(Integer id) {
        this.id = id;
        try {
            URI uri = new URI("local", "securities", String.valueOf(id));
            this.security = this.getSecurity(uri);
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        LazyStoreProperties properties = new LazyStoreProperties(this.id);
        properties.setProperty("type", IHistory.class.getName());
        properties.setProperty("security", this.security);
        properties.setProperty("bars-time-span", TimeSpan.days((int)1));
        return properties;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        this.security = (ISecurity)properties.getProperty("security");
        IOHLC[] bars = (IOHLC[])properties.getProperty("bars");
        ISplit[] splits = (ISplit[])properties.getProperty("splits");
        HistoryType historyType = new HistoryType(this.security, bars, splits, null);
        this.saveHistoryType(historyType);
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        IPath path = LocalRepository.getInstance().getLocation().append(".history");
        File file = path.append(String.valueOf(String.valueOf(this.id)) + ".xml").toFile();
        if (file.exists()) {
            file.delete();
        }
        if ((file = path.append("." + String.valueOf(this.id)).toFile()).exists()) {
            File[] childFiles = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".xml");
                }
            });
            int i = 0;
            while (i < childFiles.length) {
                childFiles[i].delete();
                ++i;
            }
            file.delete();
        }
        this.intradayStores.clear();
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        ArrayList<IntradayHistoryStore> l = new ArrayList<IntradayHistoryStore>();
        Iterator<WeakReference<IntradayHistoryStore>> iter = this.intradayStores.values().iterator();
        while (iter.hasNext()) {
            WeakReference<IntradayHistoryStore> ref = iter.next();
            IntradayHistoryStore store = (IntradayHistoryStore)ref.get();
            if (store != null && store.getFile().exists()) {
                l.add(store);
                continue;
            }
            iter.remove();
        }
        IPath path = LocalRepository.getInstance().getLocation().append(".history");
        File file = path.append("." + String.valueOf(this.id)).toFile();
        if (file.exists()) {
            File[] childFiles = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".xml");
                }
            });
            int i = 0;
            while (i < childFiles.length) {
                String name = childFiles[i].getName();
                if (!this.intradayStores.containsKey(name)) {
                    try {
                        Date date = dateFormat.parse(name.substring(0, name.length() - 4));
                        IntradayHistoryStore store = new IntradayHistoryStore(this.id, this.security, date);
                        this.intradayStores.put(name, new WeakReference<IntradayHistoryStore>(store));
                        l.add(store);
                    }
                    catch (ParseException parseException) {}
                }
                ++i;
            }
        }
        return l.toArray(new IStore[l.size()]);
    }

    public IStore createChild() {
        return null;
    }

    public URI toURI() {
        try {
            return new URI("local", "securities/history", String.valueOf(this.id));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public IRepository getRepository() {
        return Activator.getDefault().getRepository();
    }

    protected void saveHistoryType(HistoryType historyType) {
        IPath path = Activator.getDefault().getStateLocation().append(".history");
        path.toFile().mkdirs();
        this.marshal(historyType, HistoryType.class, path.append(String.valueOf(String.valueOf(this.id)) + ".xml").toFile());
    }

    protected void marshal(Object object, Class clazz, File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error validating XML: " + event.getMessage(), null);
                    Activator.getDefault().getLog().log((IStatus)status);
                    return true;
                }
            });
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
            marshaller.marshal(object, (Writer)new FileWriter(file));
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error saving securities", null);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected ISecurity getSecurity(URI uri) {
        IRepositoryService repositoryService = null;
        if (Activator.getDefault() != null) {
            try {
                BundleContext context = Activator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
                repositoryService = (IRepositoryService)context.getService(serviceReference);
                context.ungetService(serviceReference);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.repository.local", 0, "Error reading repository service", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return repositoryService != null ? repositoryService.getSecurityFromURI(uri) : null;
    }
}

