/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.repository.local.LocalRepository;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.types.HistoryDayType;
import org.eclipsetrader.repository.local.internal.types.HistoryType;

public class IntradayHistoryStore
implements IStore {
    private Integer id;
    private ISecurity security;
    private Date date;
    private Map<TimeSpan, IOHLC[]> bars = new HashMap<TimeSpan, IOHLC[]>();
    private HistoryDayType dayType;

    protected IntradayHistoryStore() {
    }

    public IntradayHistoryStore(Integer id, ISecurity security, Date date) {
        this.id = id;
        this.security = security;
        this.date = date;
    }

    public IntradayHistoryStore(Integer id, ISecurity security, HistoryDayType dayType) {
        this.id = id;
        this.security = security;
        this.date = dayType.getDate();
        this.dayType = dayType;
        HistoryType[] historyTypeArray = dayType.getPeriods();
        int n = historyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HistoryType type = historyTypeArray[n2];
            List<IOHLC> l = type.getData();
            this.bars.put(type.getPeriod(), l.toArray(new IOHLC[l.size()]));
            ++n2;
        }
    }

    public IStore createChild() {
        return null;
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
        }
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        return null;
    }

    protected void loadHistoryDayType() {
        if (this.dayType == null) {
            File file = this.getFile();
            if (file.exists()) {
                this.dayType = (HistoryDayType)this.unmarshal(HistoryDayType.class, file);
            }
            if (this.dayType == null) {
                this.dayType = new HistoryDayType(this.security, this.date);
            }
            HistoryType[] historyTypeArray = this.dayType.getPeriods();
            int n = historyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                HistoryType type = historyTypeArray[n2];
                if (!this.bars.containsKey(type.getPeriod())) {
                    List<IOHLC> l = type.getData();
                    this.bars.put(type.getPeriod(), l.toArray(new IOHLC[l.size()]));
                }
                ++n2;
            }
        }
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        StoreProperties properties = new StoreProperties(){

            public String[] getPropertyNames() {
                IntradayHistoryStore.this.loadHistoryDayType();
                HashSet<String> s = new HashSet<String>(Arrays.asList(super.getPropertyNames()));
                HistoryType[] historyTypeArray = IntradayHistoryStore.this.dayType.getPeriods();
                int n = historyTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HistoryType type = historyTypeArray[n2];
                    s.add(type.getPeriod().toString());
                    ++n2;
                }
                return s.toArray(new String[s.size()]);
            }

            public Object getProperty(String name) {
                Object o = super.getProperty(name);
                if (o != null) {
                    return o;
                }
                TimeSpan timeSpan = TimeSpan.fromString((String)name);
                if (timeSpan != null) {
                    IntradayHistoryStore.this.loadHistoryDayType();
                    return IntradayHistoryStore.this.bars.get(timeSpan);
                }
                return null;
            }
        };
        properties.setProperty("type", (Object)IHistory.class.getName());
        properties.setProperty("security", (Object)this.security);
        properties.setProperty("bars-date", (Object)this.date);
        return properties;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        this.security = (ISecurity)properties.getProperty("security");
        this.date = (Date)properties.getProperty("bars-date");
        this.loadHistoryDayType();
        String[] stringArray = properties.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            TimeSpan timeSpan = TimeSpan.fromString((String)name);
            if (timeSpan != null) {
                IOHLC[] ohlc = (IOHLC[])properties.getProperty(name);
                this.bars.put(timeSpan, ohlc);
                this.dayType.addHistory(new HistoryType(this.security, ohlc, timeSpan));
            }
            ++n2;
        }
        File file = this.getFile();
        if (this.bars.size() != 0) {
            this.marshal(this.dayType, HistoryDayType.class, file);
        } else if (file.exists()) {
            file.delete();
        }
    }

    public IRepository getRepository() {
        return Activator.getDefault().getRepository();
    }

    public URI toURI() {
        try {
            return new URI("local", "securities/history/" + new SimpleDateFormat("yyyyMMdd").format(this.date), String.valueOf(this.id));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected Object unmarshal(Class clazz, File file) {
        try {
            if (file.exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error validating XML: " + event.getMessage(), null);
                        Activator.log((IStatus)status);
                        return true;
                    }
                });
                return unmarshaller.unmarshal(file);
            }
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error loading history", null);
            Activator.log((IStatus)status);
        }
        return null;
    }

    protected void marshal(Object object, Class clazz, File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return true;
                }
            });
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
            marshaller.marshal(object, (Writer)new FileWriter(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected File getFile() {
        IPath path = LocalRepository.getInstance().getLocation().append(".history").append("." + String.valueOf(this.id));
        path.toFile().mkdirs();
        return path.append(String.valueOf(new SimpleDateFormat("yyyyMMdd").format(this.date)) + ".xml").toFile();
    }
}

