/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.net.URI;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.Script;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.instruments.ICurrencyExchange;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IStock;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.repository.local.internal.ScriptsCollection;
import org.eclipsetrader.repository.local.internal.SecurityCollection;
import org.eclipsetrader.repository.local.internal.StrategiesCollection;
import org.eclipsetrader.repository.local.internal.WatchListCollection;
import org.eclipsetrader.repository.local.internal.stores.SecurityStore;

public class RepositoryStore
implements IStore {
    private IStore store;

    public void delete(IProgressMonitor monitor) throws CoreException {
        if (this.store != null) {
            this.store.delete(monitor);
        }
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        return this.store != null ? this.store.fetchProperties(monitor) : null;
    }

    public IRepository getRepository() {
        return this.store != null ? this.store.getRepository() : null;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        if (this.store == null) {
            String type = (String)properties.getProperty("type");
            if (ISecurity.class.getName().equals(type) || IStock.class.getName().equals(type) || ICurrencyExchange.class.getName().equals(type)) {
                this.store = SecurityCollection.getInstance().create();
            } else if (IWatchList.class.getName().equals(type)) {
                this.store = WatchListCollection.getInstance().create();
            } else if (IHistory.class.getName().equals(type)) {
                ISecurity security = (ISecurity)properties.getProperty("security");
                IStoreObject storeObject = (IStoreObject)security.getAdapter(IStoreObject.class);
                IStore securityStore = storeObject.getStore();
                if (securityStore instanceof RepositoryStore) {
                    securityStore = ((RepositoryStore)securityStore).getStore();
                }
                if (securityStore instanceof SecurityStore) {
                    this.store = properties.getProperty("bars-date") != null ? ((SecurityStore)securityStore).createHistoryStore((Date)properties.getProperty("bars-date")) : ((SecurityStore)securityStore).createHistoryStore();
                }
            } else if (Script.class.getName().equals(type)) {
                this.store = ScriptsCollection.getInstance().create();
            } else if (IScriptStrategy.class.getName().equals(type)) {
                this.store = StrategiesCollection.getInstance().create();
            }
        }
        if (this.store != null) {
            this.store.putProperties(properties, monitor);
        }
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        return this.store != null ? this.store.fetchChilds(monitor) : new IStore[]{};
    }

    public IStore createChild() {
        return this.store != null ? this.store.createChild() : null;
    }

    public URI toURI() {
        return this.store != null ? this.store.toURI() : null;
    }

    public IStore getStore() {
        return this.store;
    }
}

