/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IUserProperties;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.repository.local.LocalRepository;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.SecurityCollection;
import org.eclipsetrader.repository.local.internal.stores.HistoryStore;
import org.eclipsetrader.repository.local.internal.stores.IntradayHistoryStore;
import org.eclipsetrader.repository.local.internal.stores.RepositoryStore;
import org.eclipsetrader.repository.local.internal.types.CurrencyAdapter;
import org.eclipsetrader.repository.local.internal.types.DividendType;
import org.eclipsetrader.repository.local.internal.types.FeedIdentifierAdapter;
import org.eclipsetrader.repository.local.internal.types.PropertyType;
import org.eclipsetrader.repository.local.internal.types.RepositoryFactoryAdapter;

@XmlRootElement(name="security")
public class SecurityStore
implements IStore {
    @XmlAttribute(name="id")
    private Integer id;
    @XmlAttribute(name="factory")
    @XmlJavaTypeAdapter(value=RepositoryFactoryAdapter.class)
    private IRepositoryElementFactory factory;
    @XmlAttribute(name="type")
    private String type;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="identifier")
    @XmlJavaTypeAdapter(value=FeedIdentifierAdapter.class)
    private IFeedIdentifier identifier;
    @XmlElement(name="currency")
    @XmlJavaTypeAdapter(value=CurrencyAdapter.class)
    private Currency currency;
    @XmlElementWrapper(name="dividends")
    @XmlElementRef
    private TreeSet<DividendType> dividends;
    private IUserProperties userProperties;
    @XmlElementWrapper(name="properties")
    @XmlElementRef
    private List<PropertyType> unknownProperties;
    private HistoryStore historyStore;
    private static Set<String> knownProperties = new HashSet<String>();

    static {
        knownProperties.add("factory");
        knownProperties.add("type");
        knownProperties.add("name");
        knownProperties.add("identifier");
        knownProperties.add("currency");
        knownProperties.add("dividends");
        knownProperties.add("user-properties");
    }

    public SecurityStore() {
    }

    public SecurityStore(Integer id) {
        this.id = id;
    }

    public URI toURI() {
        try {
            return new URI("local", "securities", String.valueOf(this.id));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        StoreProperties properties = new StoreProperties();
        if (this.factory != null) {
            properties.setProperty("factory", (Object)this.factory);
        }
        properties.setProperty("type", (Object)(this.type == null ? ISecurity.class.getName() : this.type));
        properties.setProperty("name", (Object)this.name);
        if (this.identifier != null) {
            properties.setProperty("identifier", (Object)this.identifier);
        }
        if (this.currency != null) {
            properties.setProperty("currency", (Object)this.currency);
        }
        properties.setProperty("user-properties", (Object)this.userProperties);
        if (this.dividends != null) {
            int i = 0;
            IDividend[] dividends = new IDividend[this.dividends.size()];
            for (DividendType type : this.dividends) {
                dividends[i++] = type.getDividend();
            }
            properties.setProperty("dividends", (Object)dividends);
        }
        if (this.unknownProperties != null) {
            for (PropertyType property : this.unknownProperties) {
                properties.setProperty(property.getName(), PropertyType.convert(property));
            }
        }
        return properties;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        this.factory = (IRepositoryElementFactory)properties.getProperty("factory");
        this.type = (String)properties.getProperty("type");
        this.name = (String)properties.getProperty("name");
        this.identifier = (IFeedIdentifier)properties.getProperty("identifier");
        this.currency = (Currency)properties.getProperty("currency");
        this.userProperties = (IUserProperties)properties.getProperty("user-properties");
        IDividend[] dividends = (IDividend[])properties.getProperty("dividends");
        if (dividends != null) {
            this.dividends = new TreeSet();
            int i = 0;
            while (i < dividends.length) {
                this.dividends.add(new DividendType(dividends[i]));
                ++i;
            }
        } else {
            this.dividends = null;
        }
        this.unknownProperties = new ArrayList<PropertyType>();
        String[] stringArray = properties.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!knownProperties.contains(name)) {
                this.unknownProperties.add(PropertyType.create(name, properties.getProperty(name)));
            }
            ++n2;
        }
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        IPath path;
        File file;
        SecurityCollection.getInstance().delete(this);
        if (this.historyStore == null && (file = (path = LocalRepository.getInstance().getLocation().append(".history")).append(String.valueOf(String.valueOf(this.id)) + ".xml").toFile()).exists()) {
            this.historyStore = new HistoryStore(this.id);
        }
        if (this.historyStore != null) {
            this.historyStore.delete(monitor);
        }
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        IPath path;
        File file;
        if (this.historyStore == null && (file = (path = LocalRepository.getInstance().getLocation().append(".history")).append(String.valueOf(String.valueOf(this.id)) + ".xml").toFile()).exists()) {
            this.historyStore = new HistoryStore(this.id);
        }
        ArrayList<HistoryStore> l = new ArrayList<HistoryStore>();
        if (this.historyStore != null) {
            l.add(this.historyStore);
        }
        return l.toArray(new IStore[l.size()]);
    }

    public IStore createChild() {
        return new RepositoryStore();
    }

    @XmlTransient
    public IRepository getRepository() {
        return Activator.getDefault().getRepository();
    }

    public HistoryStore createHistoryStore() {
        this.historyStore = new HistoryStore(this.id);
        return this.historyStore;
    }

    public IStore createHistoryStore(Date date) {
        return new IntradayHistoryStore(this.id, null, date);
    }
}

