/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.IScript;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.StrategiesCollection;
import org.eclipsetrader.repository.local.internal.types.RepositoryFactoryAdapter;
import org.eclipsetrader.repository.local.internal.types.ScriptAdapter;
import org.eclipsetrader.repository.local.internal.types.SecurityAdapter;
import org.eclipsetrader.repository.local.internal.types.TimeSpanAdapter;

@XmlRootElement(name="strategy")
public class StrategyScriptStore
implements IStore {
    @XmlAttribute(name="id")
    private Integer id;
    @XmlAttribute(name="factory")
    @XmlJavaTypeAdapter(value=RepositoryFactoryAdapter.class)
    private IRepositoryElementFactory factory;
    @XmlAttribute(name="type")
    private String type;
    @XmlAttribute(name="language")
    private String language;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="text")
    private String text;
    @XmlElementWrapper(name="bars")
    @XmlElement(name="timeSpan")
    @XmlJavaTypeAdapter(value=TimeSpanAdapter.class)
    private List<TimeSpan> barsTimeSpan = new ArrayList<TimeSpan>();
    @XmlElementWrapper(name="instruments")
    @XmlElement(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private List<ISecurity> instruments = new ArrayList<ISecurity>();
    @XmlElementWrapper(name="includes")
    @XmlElement(name="script")
    @XmlJavaTypeAdapter(value=ScriptAdapter.class)
    private List<IScript> includes = new ArrayList<IScript>();

    public StrategyScriptStore() {
    }

    public StrategyScriptStore(Integer id) {
        this.id = id;
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        StoreProperties properties = new StoreProperties();
        if (this.factory != null) {
            properties.setProperty("factory", (Object)this.factory);
        }
        properties.setProperty("type", (Object)this.type);
        properties.setProperty("name", (Object)this.name);
        properties.setProperty("language", (Object)this.language);
        properties.setProperty("text", (Object)this.text);
        properties.setProperty("includes", (Object)this.includes.toArray(new IScript[this.includes.size()]));
        properties.setProperty("instruments", (Object)this.instruments.toArray(new ISecurity[this.instruments.size()]));
        properties.setProperty("barsTimeSpan", (Object)this.barsTimeSpan.toArray(new TimeSpan[this.barsTimeSpan.size()]));
        return properties;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        this.factory = (IRepositoryElementFactory)properties.getProperty("factory");
        this.type = (String)properties.getProperty("type");
        this.name = (String)properties.getProperty("name");
        this.language = (String)properties.getProperty("language");
        this.text = (String)properties.getProperty("text");
        this.includes = new ArrayList<IScript>();
        IScript[] s = (IScript[])properties.getProperty("includes");
        if (s != null) {
            this.includes.addAll(Arrays.asList(s));
        }
        this.instruments = new ArrayList<ISecurity>();
        ISecurity[] e = (ISecurity[])properties.getProperty("instruments");
        if (e != null) {
            this.instruments.addAll(Arrays.asList(e));
        }
        this.barsTimeSpan = new ArrayList<TimeSpan>();
        TimeSpan[] barsTimeSpan = (TimeSpan[])properties.getProperty("barsTimeSpan");
        if (barsTimeSpan != null) {
            this.barsTimeSpan.addAll(Arrays.asList(barsTimeSpan));
        }
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        StrategiesCollection.getInstance().delete(this);
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        return null;
    }

    public IStore createChild() {
        return null;
    }

    @XmlTransient
    public IRepository getRepository() {
        return Activator.getDefault().getRepository();
    }

    public URI toURI() {
        try {
            return new URI("local", "strategies", String.valueOf(this.id));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

