/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.types.DateTimeAdapter;
import org.eclipsetrader.repository.local.internal.types.SecurityAdapter;

@XmlRootElement(name="trade")
public class TradeStore
implements IStore {
    @XmlAttribute(name="id")
    private Integer id;
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    @XmlAttribute(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private ISecurity security;
    @XmlAttribute(name="quantity")
    private Long quantity;
    @XmlAttribute(name="price")
    private Double price;

    protected TradeStore() {
    }

    public TradeStore(Integer id) {
        this.id = id;
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        StoreProperties properties = new StoreProperties();
        properties.setProperty("type", (Object)IHolding.class.getName());
        properties.setProperty("purchase-date", (Object)this.date);
        properties.setProperty("security", (Object)this.security);
        properties.setProperty("purchase-date", (Object)this.security);
        properties.setProperty("purchase-quantity", (Object)this.quantity);
        properties.setProperty("purchase-price", (Object)this.price);
        return properties;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        this.date = (Date)properties.getProperty("purchase-date");
        this.security = (ISecurity)properties.getProperty("security");
        this.quantity = (Long)properties.getProperty("purchase-quantity");
        this.price = (Double)properties.getProperty("purchase-price");
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        return new IStore[0];
    }

    public IStore createChild() {
        return null;
    }

    @XmlTransient
    public IRepository getRepository() {
        return Activator.getDefault().getRepository();
    }

    public URI toURI() {
        try {
            return new URI("local", "trades", String.valueOf(this.id));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

