/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.core.views.IColumn;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.WatchListCollection;
import org.eclipsetrader.repository.local.internal.types.ColumnAdapter;
import org.eclipsetrader.repository.local.internal.types.HoldingAdapter;
import org.eclipsetrader.repository.local.internal.types.PropertyType;
import org.eclipsetrader.repository.local.internal.types.RepositoryFactoryAdapter;

@XmlRootElement(name="watchlist")
public class WatchListStore
implements IStore {
    @XmlAttribute(name="id")
    private Integer id;
    @XmlAttribute(name="factory")
    @XmlJavaTypeAdapter(value=RepositoryFactoryAdapter.class)
    private IRepositoryElementFactory factory;
    @XmlElement(name="name")
    private String name;
    @XmlElementWrapper(name="columns")
    @XmlElementRef
    @XmlJavaTypeAdapter(value=ColumnAdapter.class)
    private List<IColumn> columns = new ArrayList<IColumn>();
    @XmlElementWrapper(name="elements")
    @XmlElementRef
    @XmlJavaTypeAdapter(value=HoldingAdapter.class)
    private List<IHolding> elements = new ArrayList<IHolding>();
    @XmlElementWrapper(name="properties")
    @XmlElementRef
    private List<PropertyType> unknownProperties;
    private static Set<String> knownProperties = new HashSet<String>();

    static {
        knownProperties.add("factory");
        knownProperties.add("type");
        knownProperties.add("name");
        knownProperties.add("columns");
        knownProperties.add("holdings");
    }

    public WatchListStore() {
    }

    public WatchListStore(Integer id) {
        this.id = id;
    }

    public URI toURI() {
        try {
            return new URI("local", "watchlists", String.valueOf(this.id));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        StoreProperties properties = new StoreProperties();
        properties.setProperty("factory", (Object)this.factory);
        properties.setProperty("type", (Object)IWatchList.class.getName());
        properties.setProperty("name", (Object)this.name);
        properties.setProperty("columns", (Object)this.columns.toArray(new IColumn[this.columns.size()]));
        properties.setProperty("holdings", (Object)this.elements.toArray(new IHolding[this.elements.size()]));
        if (this.unknownProperties != null) {
            for (PropertyType property : this.unknownProperties) {
                properties.setProperty(property.getName(), PropertyType.convert(property));
            }
        }
        return properties;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        this.factory = (IRepositoryElementFactory)properties.getProperty("factory");
        this.name = (String)properties.getProperty("name");
        IHolding[] e = (IHolding[])properties.getProperty("holdings");
        this.elements = e != null ? new ArrayList<IHolding>(Arrays.asList(e)) : new ArrayList();
        IColumn[] c = (IColumn[])properties.getProperty("columns");
        this.columns = c != null ? new ArrayList<IColumn>(Arrays.asList(c)) : new ArrayList();
        this.unknownProperties = new ArrayList<PropertyType>();
        String[] stringArray = properties.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!knownProperties.contains(name)) {
                this.unknownProperties.add(PropertyType.create(name, properties.getProperty(name)));
            }
            ++n2;
        }
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        WatchListCollection.getInstance().delete(this);
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        return new IStore[0];
    }

    public IStore createChild() {
        return null;
    }

    @XmlTransient
    public IRepository getRepository() {
        return Activator.getDefault().getRepository();
    }
}

