/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.repository.local.internal.Activator;

public class RepositoryFactoryAdapter
extends XmlAdapter<String, IRepositoryElementFactory> {
    private static final String ELEMENT_FACTORY_ID = "org.eclipsetrader.core.elementFactories";

    public String marshal(IRepositoryElementFactory v) throws Exception {
        return v != null ? v.getId() : null;
    }

    public IRepositoryElementFactory unmarshal(String v) throws Exception {
        return v != null ? this.getFactory(v) : null;
    }

    protected IRepositoryElementFactory getFactory(String id) {
        IConfigurationElement[] configElements = this.getConfigurationElements();
        if (configElements == null) {
            return null;
        }
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (id.equals(strID)) {
                try {
                    IRepositoryElementFactory factory = (IRepositoryElementFactory)configElements[j].createExecutableExtension("class");
                    return factory;
                }
                catch (Exception e) {
                    Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Unable to create factory with id " + id, (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    break;
                }
            }
            ++j;
        }
        return null;
    }

    protected IConfigurationElement[] getConfigurationElements() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ELEMENT_FACTORY_ID);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getConfigurationElements();
    }
}

