/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.Split;
import org.eclipsetrader.repository.local.internal.types.DateAdapter;
import org.eclipsetrader.repository.local.internal.types.DividendType;
import org.eclipsetrader.repository.local.internal.types.DoubleValueAdapter;

@XmlRootElement(name="split")
public class SplitType
implements Comparable<Object> {
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date date;
    @XmlAttribute(name="old-quantity")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double oldQuantity;
    @XmlAttribute(name="new-quantity")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double newQuantity;

    public SplitType() {
    }

    public SplitType(ISplit split) {
        this.date = split.getDate();
        this.oldQuantity = split.getOldQuantity();
        this.newQuantity = split.getNewQuantity();
    }

    public Date getDate() {
        return this.date;
    }

    public ISplit getSplit() {
        return new Split(this.date, this.oldQuantity.doubleValue(), this.newQuantity.doubleValue());
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof DividendType) {
            return this.date.compareTo(((DividendType)o).getExDate());
        }
        if (o instanceof SplitType) {
            return this.date.compareTo(((SplitType)o).getDate());
        }
        return 0;
    }
}

