/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats;

import java.util.Date;
import org.eclipsetrader.core.ats.IBarFactory;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;

public class BarFactoryEvent {
    public Date date;
    public Double open;
    public Double high;
    public Double low;
    public Double close;
    public Long volume;
    public ISecurity security;
    public TimeSpan timeSpan;
    public IBarFactory factory;

    public BarFactoryEvent() {
    }

    public BarFactoryEvent(ISecurity security, TimeSpan timeSpan, Date date, Double open) {
        this.security = security;
        this.timeSpan = timeSpan;
        this.date = date;
        this.open = open;
    }

    public BarFactoryEvent(ISecurity security, TimeSpan timeSpan, Date date, Double open, Double high, Double low, Double close, Long volume) {
        this.security = security;
        this.timeSpan = timeSpan;
        this.date = date;
        this.open = open;
        this.high = high;
        this.low = low;
        this.close = close;
        this.volume = volume;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[BarFactoryEvent:");
        sb.append(" instrument=" + this.security.getName());
        sb.append(" date=" + this.date);
        if (this.open != null) {
            sb.append(" open=" + this.open);
        }
        if (this.high != null) {
            sb.append(" high=" + this.high);
        }
        if (this.low != null) {
            sb.append(" low=" + this.low);
        }
        if (this.close != null) {
            sb.append(" close=" + this.close);
        }
        if (this.volume != null) {
            sb.append(" volume=" + this.volume);
        }
        return sb.toString();
    }
}

