/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats;

import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.IScript;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;

public class ScriptStrategy
implements IScriptStrategy,
IStoreObject,
IAdaptable {
    private String name;
    private String language;
    private String text;
    private List<IScript> includes = new ArrayList<IScript>();
    private ISecurity[] instruments;
    private List<TimeSpan> barsTimeSpan = new ArrayList<TimeSpan>();
    private IStore store;
    private IStoreProperties storeProperties;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ScriptStrategy() {
    }

    public ScriptStrategy(String name) {
        this.name = name;
    }

    public ScriptStrategy(IStore store, IStoreProperties storeProperties) {
        this.setStore(store);
        this.setStoreProperties(storeProperties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        this.propertyChangeSupport.firePropertyChange("language", this.language, this.language);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.propertyChangeSupport.firePropertyChange("text", this.text, this.text);
    }

    @Override
    public IScript[] getIncludes() {
        return this.includes.toArray(new IScript[this.includes.size()]);
    }

    public void setIncludes(IScript[] includes) {
        ArrayList<IScript> newIncludes = new ArrayList<IScript>();
        if (includes != null) {
            newIncludes.addAll(Arrays.asList(includes));
        }
        this.includes = newIncludes;
        this.propertyChangeSupport.firePropertyChange("includes", this.includes, this.includes);
    }

    @Override
    public ISecurity[] getInstruments() {
        return this.instruments != null ? this.instruments : new ISecurity[]{};
    }

    public void setInstruments(ISecurity[] instruments) {
        this.instruments = instruments;
        this.propertyChangeSupport.firePropertyChange("instruments", this.instruments, instruments);
    }

    @Override
    public TimeSpan[] getBarsTimeSpan() {
        return this.barsTimeSpan.toArray(new TimeSpan[this.barsTimeSpan.size()]);
    }

    public void setBarsTimeSpan(TimeSpan[] barsTimeSpan) {
        ArrayList<TimeSpan> newBarsTimeSpan = new ArrayList<TimeSpan>();
        if (barsTimeSpan != null) {
            newBarsTimeSpan.addAll(Arrays.asList(barsTimeSpan));
        }
        this.barsTimeSpan = newBarsTimeSpan;
        this.propertyChangeSupport.firePropertyChange("barsTimeSpan", this.barsTimeSpan, this.barsTimeSpan);
    }

    @Override
    public IStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IStore store) {
        this.store = store;
    }

    @Override
    public IStoreProperties getStoreProperties() {
        if (this.storeProperties == null) {
            this.storeProperties = new StoreProperties();
        }
        this.storeProperties.setProperty("type", IScriptStrategy.class.getName());
        this.storeProperties.setProperty("name", this.name);
        this.storeProperties.setProperty("language", this.language);
        this.storeProperties.setProperty("text", this.text);
        this.storeProperties.setProperty("includes", this.getIncludes());
        this.storeProperties.setProperty("instruments", this.instruments);
        this.storeProperties.setProperty("barsTimeSpan", this.getBarsTimeSpan());
        return this.storeProperties;
    }

    @Override
    public void setStoreProperties(IStoreProperties storeProperties) {
        this.storeProperties = storeProperties;
        this.name = (String)storeProperties.getProperty("name");
        this.language = (String)storeProperties.getProperty("language");
        this.text = (String)storeProperties.getProperty("text");
        IScript[] includes = (IScript[])storeProperties.getProperty("includes");
        this.includes = new ArrayList<IScript>();
        if (includes != null) {
            this.includes.addAll(Arrays.asList(includes));
        }
        this.instruments = (ISecurity[])storeProperties.getProperty("instruments");
        this.barsTimeSpan = new ArrayList<TimeSpan>();
        TimeSpan[] barsTimeSpan = (TimeSpan[])storeProperties.getProperty("barsTimeSpan");
        if (barsTimeSpan != null) {
            this.barsTimeSpan.addAll(Arrays.asList(barsTimeSpan));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(URI.class) && this.store != null) {
            return this.store.toURI();
        }
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

