/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.engines;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipsetrader.core.charts.BarsDataSeries;
import org.eclipsetrader.core.feed.IBar;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class BarsDataSeriesFunction
extends ScriptableObject {
    private static final long serialVersionUID = 5619130687789322561L;
    public static final String FUNCTION_NAME = "BarsDataSeries";
    public static final String PROP_BARS = "BARS";
    private final List<IBar> list = new ArrayList<IBar>();
    private final BarsDataSeries series = new BarsDataSeries("BARS", this.list);
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);

    public BarsDataSeries getSeries() {
        return this.series;
    }

    public static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        return new BarsDataSeriesFunction();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void append(IBar element) {
        this.list.add(element);
        this.changeSupport.firePropertyChange(PROP_BARS, null, this.toArray());
    }

    public void prepend(IBar element) {
        this.list.add(0, element);
        this.changeSupport.firePropertyChange(PROP_BARS, null, this.toArray());
    }

    public String getClassName() {
        return FUNCTION_NAME;
    }

    public Object get(int index, Scriptable start) {
        try {
            int s = this.list.size();
            if (index >= 0 && index < s) {
                return this.list.get(index);
            }
            return Context.getUndefinedValue();
        }
        catch (RuntimeException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    public Object[] getIds() {
        int size = this.list.size();
        Object[] ids = new Integer[size];
        int i = 0;
        while (i < size) {
            ids[i] = i;
            ++i;
        }
        return ids;
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.list.size();
    }

    public Object jsFunction_size() {
        return this.list.size();
    }

    public Object jsFunction_first() {
        return this.list.size() != 0 ? this.list.get(0) : null;
    }

    public Object jsFunction_last() {
        return this.list.size() != 0 ? this.list.get(this.list.size() - 1) : null;
    }

    public IBar[] toArray() {
        return this.list.toArray(new IBar[this.list.size()]);
    }
}

