/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.engines;

import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IOrderType;
import org.eclipsetrader.core.trading.Order;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public abstract class BaseOrderFunction
extends ScriptableObject {
    private static final long serialVersionUID = 7916839001932000909L;
    public static final int Buy = 0;
    public static final int Sell = 1;
    public static final int Limit = 0;
    public static final int Market = 1;
    public static final String PROPERTY_ACCOUNT = "account";
    public static final String PROPERTY_BROKER = "broker";
    public static final String PROPERTY_INSTRUMENT = "instrument";
    private IBroker broker;
    private IAccount account;
    private ISecurity instrument;
    protected IOrderType type;
    protected IOrderSide side;
    protected long quantity;
    protected Double price;
    protected String text;
    private IOrderMonitor monitor;

    public BaseOrderFunction() {
    }

    public BaseOrderFunction(IBroker broker, IAccount account, ISecurity instrument) {
        this.broker = broker;
        this.account = account;
        this.instrument = instrument;
    }

    public double jsGet_type() {
        if (this.type == IOrderType.Limit) {
            return 0.0;
        }
        if (this.type == IOrderType.Market) {
            return 1.0;
        }
        return -1.0;
    }

    public void jsSet_type(Object arg) {
        switch ((int)Context.toNumber((Object)arg)) {
            case 0: {
                this.type = IOrderType.Limit;
                break;
            }
            case 1: {
                this.type = IOrderType.Market;
            }
        }
    }

    public double jsGet_side() {
        if (this.side == IOrderSide.Buy) {
            return 0.0;
        }
        if (this.side == IOrderSide.Sell) {
            return 1.0;
        }
        return -1.0;
    }

    public void jsSet_side(Object arg) {
        switch ((int)Context.toNumber((Object)arg)) {
            case 0: {
                this.side = IOrderSide.Buy;
                break;
            }
            case 1: {
                this.side = IOrderSide.Sell;
            }
        }
    }

    public double jsGet_quantity() {
        return this.quantity;
    }

    public void jsSet_quantity(Object arg) {
        this.quantity = (int)Context.toNumber((Object)arg);
    }

    public double jsGet_price() {
        return this.price;
    }

    public void jsSet_price(Object arg) {
        this.price = Context.toNumber((Object)arg);
    }

    public String jsGet_text() {
        return this.text;
    }

    public void jsSet_text(Object arg) {
        this.text = Context.toString((Object)arg);
    }

    public Object jsFunction_send() throws Exception {
        Order order = new Order(this.account, this.type, this.side, this.instrument, this.quantity, this.price);
        order.setReference(this.text);
        this.monitor = this.broker.prepareOrder(order);
        this.monitor.submit();
        return null;
    }

    public Object jsFunction_cancel() throws Exception {
        if (this.monitor != null) {
            this.monitor.cancel();
        }
        return null;
    }
}

