/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.engines;

import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class EnhancedWrapFactory
extends WrapFactory {
    public EnhancedWrapFactory() {
        this.setJavaPrimitiveWrap(false);
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
        if (javaObject instanceof Map) {
            return new NativeMapAdapter(scope, javaObject, staticType);
        }
        if (javaObject instanceof List) {
            return new NativeListAdapter(scope, javaObject, staticType);
        }
        return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
    }

    public class NativeListAdapter
    extends NativeJavaObject {
        private static final long serialVersionUID = -1246405314430811811L;

        public NativeListAdapter(Scriptable scope, Object javaObject, Class staticType) {
            super(scope, javaObject, staticType);
        }

        private List getList() {
            return (List)this.javaObject;
        }

        public Object get(String name, Scriptable start) {
            if (name.equals("length")) {
                return this.getList().size();
            }
            return super.get(name, start);
        }

        public void delete(int index) {
            try {
                this.getList().remove(index);
            }
            catch (RuntimeException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }

        public Object get(int index, Scriptable start) {
            try {
                int s = this.getList().size();
                if (index >= 0 && index < s) {
                    return this.getList().get(index);
                }
                return Context.getUndefinedValue();
            }
            catch (RuntimeException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }

        public String getClassName() {
            return "NativeListAdapter";
        }

        public Object[] getIds() {
            int size = this.getList().size();
            Object[] ids = new Integer[size];
            int i = 0;
            while (i < size) {
                ids[i] = i;
                ++i;
            }
            return ids;
        }

        public boolean has(int index, Scriptable start) {
            return index >= 0 && index < this.getList().size();
        }

        public void put(int index, Scriptable start, Object value) {
            try {
                this.getList().set(index, Context.jsToJava((Object)value, (Class)ScriptRuntime.ObjectClass));
            }
            catch (RuntimeException e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }

        public String toString() {
            return this.javaObject.toString();
        }
    }

    public class NativeMapAdapter
    extends NativeJavaObject {
        private static final long serialVersionUID = 3722239924401421834L;

        public NativeMapAdapter(Scriptable scope, Object javaObject, Class staticType) {
            super(scope, javaObject, staticType);
        }

        private Map getMap() {
            return (Map)this.javaObject;
        }

        public void delete(String name) {
            try {
                this.getMap().remove(name);
            }
            catch (RuntimeException e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }

        public Object get(String name, Scriptable start) {
            Object value = super.get(name, start);
            if (value != Scriptable.NOT_FOUND) {
                return value;
            }
            value = this.getMap().get(name);
            if (value == null) {
                return Scriptable.NOT_FOUND;
            }
            return value;
        }

        public String getClassName() {
            return "NativeMapAdapter";
        }

        public Object[] getIds() {
            return this.getMap().keySet().toArray();
        }

        public boolean has(String name, Scriptable start) {
            return this.getMap().containsKey(name) || super.has(name, start);
        }

        public void put(String name, Scriptable start, Object value) {
            try {
                this.getMap().put(name, Context.jsToJava((Object)value, (Class)ScriptRuntime.ObjectClass));
            }
            catch (RuntimeException e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }

        public String toString() {
            return this.javaObject.toString();
        }
    }
}

