/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.engines;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.ats.engines.BarsDataSeriesFunction;
import org.eclipsetrader.core.charts.IDataSeries;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class IndicatorFunction
extends ScriptableObject {
    private static final long serialVersionUID = -9191442400382251716L;
    public static final String PROP_SERIES = "SERIES";
    protected IDataSeries source;
    protected IDataSeries series;
    protected final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    private final PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IndicatorFunction.this.calculate();
        }
    };

    public IndicatorFunction() {
    }

    public IndicatorFunction(BarsDataSeriesFunction bars) {
        this.source = bars.getSeries();
        bars.addPropertyChangeListener("BARS", this.changeListener);
    }

    public IndicatorFunction(IndicatorFunction indicator) {
        this.source = indicator.getSeries();
        indicator.addPropertyChangeListener(PROP_SERIES, this.changeListener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected abstract void calculate();

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Object get(String name, Scriptable start) {
        if (name.equals("length")) {
            return this.series != null ? this.series.size() : 0;
        }
        return super.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        if (this.series == null) {
            return Context.getUndefinedValue();
        }
        try {
            int s = this.series.size();
            if (index >= 0 && index < s) {
                return this.series.getValues()[index];
            }
            return Context.getUndefinedValue();
        }
        catch (RuntimeException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    public Object[] getIds() {
        int size = this.series.size();
        Object[] ids = new Integer[size];
        int i = 0;
        while (i < size) {
            ids[i] = i;
            ++i;
        }
        return ids;
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.series.size();
    }

    public Object jsFunction_crosses(IndicatorFunction other, Object bar) {
        return this.series.cross(other.series, (IAdaptable)bar);
    }

    public Object jsFunction_first() {
        return this.series.getFirst();
    }

    public Object jsFunction_last() {
        return this.series.getLast();
    }

    public Object jsFunction_highest() {
        return this.series.getHighest();
    }

    public Object jsFunction_lowest() {
        return this.series.getLowest();
    }

    public IDataSeries getSeries() {
        return this.series;
    }
}

