/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.engines;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.ats.ITradingSystem;
import org.eclipsetrader.core.ats.ITradingSystemContext;
import org.eclipsetrader.core.ats.ITradingSystemInstrument;
import org.eclipsetrader.core.ats.engines.EngineEvent;
import org.eclipsetrader.core.ats.engines.EnhancedWrapFactory;
import org.eclipsetrader.core.ats.engines.JavaScriptEngineInstrument;
import org.eclipsetrader.core.feed.IBar;
import org.eclipsetrader.core.feed.IBarOpen;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.trading.IPositionListener;
import org.eclipsetrader.core.trading.PositionEvent;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

public class JavaScriptEngine
extends Observable {
    public static final String PROPERTY_INSTRUMENTS = "instruments";
    public static final String PROPERTY_POSITIONS = "positions";
    public static final String PROPERTY_MARKET = "market";
    public static final String PROPERTY_BARSIZE = "barSize";
    private final ITradingSystem tradingSystem;
    private final ITradingSystemContext context;
    private final IScriptStrategy strategy;
    private final IPricingEnvironment pricingEnvironment;
    private final IAccount account;
    private final IBroker broker;
    private ScriptableObject scope;
    private Map<String, Object> instrumentsMap = new HashMap<String, Object>();
    private Map<Object, IPosition> positionsMap = new HashMap<Object, IPosition>();
    private Map<ISecurity, JavaScriptEngineInstrument> contextsMap = new HashMap<ISecurity, JavaScriptEngineInstrument>();
    public IPricingListener pricingListener = new IPricingListener(){

        @Override
        public void pricingUpdate(PricingEvent event) {
            JavaScriptEngine.this.doPricingUpdate(event);
        }
    };
    private IPositionListener positionListener = new IPositionListener(){

        @Override
        public void positionOpened(PositionEvent e) {
            JavaScriptEngineInstrument context = (JavaScriptEngineInstrument)JavaScriptEngine.this.contextsMap.get(e.position.getSecurity());
            if (context == null) {
                return;
            }
            context.onPositionOpen(e.position);
            JavaScriptEngine.this.updatePositionsMap();
            JavaScriptEngine.this.setChanged();
            JavaScriptEngine.this.notifyObservers(new EngineEvent(e.position.getSecurity(), e.position));
        }

        @Override
        public void positionClosed(PositionEvent e) {
            JavaScriptEngineInstrument context = (JavaScriptEngineInstrument)JavaScriptEngine.this.contextsMap.get(e.position.getSecurity());
            if (context == null) {
                return;
            }
            context.onPositionClosed(e.position);
            JavaScriptEngine.this.updatePositionsMap();
            JavaScriptEngine.this.setChanged();
            JavaScriptEngine.this.notifyObservers(new EngineEvent(e.position.getSecurity(), e.position));
        }

        @Override
        public void positionChanged(PositionEvent e) {
            JavaScriptEngineInstrument context = (JavaScriptEngineInstrument)JavaScriptEngine.this.contextsMap.get(e.position.getSecurity());
            if (context == null) {
                return;
            }
            context.onPositionChange(e.position);
            JavaScriptEngine.this.updatePositionsMap();
            JavaScriptEngine.this.setChanged();
            JavaScriptEngine.this.notifyObservers(new EngineEvent(e.position.getSecurity(), e.position));
        }
    };

    public JavaScriptEngine(ITradingSystem tradingSystem, ITradingSystemContext context) {
        this.tradingSystem = tradingSystem;
        this.context = context;
        this.strategy = (IScriptStrategy)tradingSystem.getStrategy();
        this.pricingEnvironment = context.getPricingEnvironment();
        this.account = context.getAccount();
        this.broker = context.getBroker();
    }

    public void start() throws Exception {
        Context cx = Context.enter();
        try {
            cx.setWrapFactory((WrapFactory)new EnhancedWrapFactory());
            this.scope = new ImporterTopLevel(cx);
            this.scope.putConst("Buy", (Scriptable)this.scope, (Object)0);
            this.scope.putConst("Sell", (Scriptable)this.scope, (Object)1);
            this.scope.putConst("Limit", (Scriptable)this.scope, (Object)0);
            this.scope.putConst("Market", (Scriptable)this.scope, (Object)1);
            this.scope.putConst("Above", (Scriptable)this.scope, (Object)1);
            this.scope.putConst("Below", (Scriptable)this.scope, (Object)-1);
            this.scope.putConst("None", (Scriptable)this.scope, (Object)0);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"account", (Object)Context.javaToJS((Object)this.account, (Scriptable)this.scope));
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"broker", (Object)Context.javaToJS((Object)this.broker, (Scriptable)this.scope));
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_INSTRUMENTS, this.instrumentsMap);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_POSITIONS, this.positionsMap);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_BARSIZE, (Object)this.tradingSystem.getStrategy().getBarsTimeSpan());
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"out", (Object)Context.javaToJS((Object)System.out, (Scriptable)this.scope));
            this.updatePositionsMap();
            int backfillSize = this.context.getInitialBackfillSize();
            ITradingSystemInstrument[] iTradingSystemInstrumentArray = this.tradingSystem.getInstruments();
            int n = iTradingSystemInstrumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITradingSystemInstrument instrument = iTradingSystemInstrumentArray[n2];
                ISecurity security = instrument.getInstrument();
                JavaScriptEngineInstrument engineInstrument = new JavaScriptEngineInstrument((Scriptable)this.scope, security, this.strategy);
                if (backfillSize != 0) {
                    engineInstrument.backfill(backfillSize);
                }
                if (security.getIdentifier() != null) {
                    Object jsInstrument = engineInstrument.getScope().get("instrument", engineInstrument.getScope());
                    this.instrumentsMap.put(security.getIdentifier().getSymbol(), jsInstrument);
                }
                engineInstrument.setPosition(this.positionsMap.get(security));
                this.contextsMap.put(instrument.getInstrument(), engineInstrument);
                ++n2;
            }
            for (JavaScriptEngineInstrument engineInstrument : this.contextsMap.values()) {
                engineInstrument.onStrategyStart();
            }
            this.account.addPositionListener(this.positionListener);
            this.pricingEnvironment.addPricingListener(this.pricingListener);
        }
        finally {
            Context.exit();
        }
    }

    public void stop() {
        this.contextsMap.clear();
        this.instrumentsMap.clear();
        this.positionsMap.clear();
        this.account.removePositionListener(this.positionListener);
        this.pricingEnvironment.removePricingListener(this.pricingListener);
        this.scope = null;
    }

    public void dispose() {
        this.deleteObservers();
    }

    void doPricingUpdate(PricingEvent event) {
        JavaScriptEngineInstrument instrument = this.contextsMap.get(event.getSecurity());
        if (instrument == null) {
            return;
        }
        PricingDelta[] pricingDeltaArray = event.getDelta();
        int n = pricingDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            PricingDelta delta = pricingDeltaArray[n2];
            Object value = delta.getNewValue();
            if (value instanceof IQuote) {
                instrument.onQuote((IQuote)value);
                this.setChanged();
                this.notifyObservers(new EngineEvent(event.getSecurity(), value));
            } else if (value instanceof ITrade) {
                instrument.onTrade((ITrade)value);
                this.setChanged();
                this.notifyObservers(new EngineEvent(event.getSecurity(), value));
            } else if (value instanceof IBarOpen) {
                instrument.onBarOpen((IBarOpen)value);
                this.setChanged();
                this.notifyObservers(new EngineEvent(event.getSecurity(), value));
            } else if (value instanceof IBar) {
                instrument.onBar((IBar)value);
                this.setChanged();
                this.notifyObservers(new EngineEvent(event.getSecurity(), instrument.getBars()));
            }
            ++n2;
        }
    }

    void updatePositionsMap() {
        this.positionsMap.clear();
        IPosition[] iPositionArray = this.account.getPositions();
        int n = iPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPosition position = iPositionArray[n2];
            ISecurity security = position.getSecurity();
            if (security.getIdentifier() != null) {
                this.positionsMap.put(security.getIdentifier().getSymbol(), position);
                this.positionsMap.put(security, position);
            }
            ++n2;
        }
    }

    public Object get(String name) {
        return this.scope.get(name, (Scriptable)this.scope);
    }

    public ScriptableObject getScope() {
        return this.scope;
    }

    public JavaScriptEngineInstrument getContextFor(ISecurity security) {
        return this.contextsMap.get(security);
    }
}

