/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.Cash;
import org.eclipsetrader.core.ats.simulation.OrderMonitor;
import org.eclipsetrader.core.ats.simulation.Position;
import org.eclipsetrader.core.ats.simulation.Transaction;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.trading.IPositionListener;
import org.eclipsetrader.core.trading.ITransaction;
import org.eclipsetrader.core.trading.PositionEvent;

public class Account
implements IAccount {
    private final String id;
    private Double balance = 0.0;
    private final List<Transaction> transactions = new ArrayList<Transaction>();
    private final Map<ISecurity, Position> positions = new HashMap<ISecurity, Position>();
    private final ListenerList listeners = new ListenerList();

    public Account() {
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return "Simulated Account";
    }

    @Override
    public Cash getBalance() {
        return new Cash(this.balance, Currency.getInstance(Locale.getDefault()));
    }

    @Override
    public ITransaction[] getTransactions() {
        return this.transactions.toArray(new ITransaction[this.transactions.size()]);
    }

    @Override
    public IPosition[] getPositions() {
        Collection<Position> c = this.positions.values();
        return c.toArray(new IPosition[c.size()]);
    }

    @Override
    public void addPositionListener(IPositionListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePositionListener(IPositionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void processCompletedOrder(OrderMonitor monitor) {
        Transaction transaction = new Transaction(monitor, monitor.getOrder().getDate());
        monitor.setTransaction(transaction);
        this.transactions.add(transaction);
        Long quantity = monitor.getOrder().getSide() == IOrderSide.Sell ? -monitor.getFilledQuantity().longValue() : monitor.getFilledQuantity();
        double averagePrice = transaction.getAmount().getAmount() / (double)monitor.getFilledQuantity().longValue();
        this.balance = this.balance - (double)quantity.longValue() * averagePrice;
        Position position = this.positions.get(monitor.getOrder().getSecurity());
        if (position == null) {
            position = new Position(monitor.getOrder().getSecurity(), quantity, averagePrice);
            this.positions.put(position.getSecurity(), position);
            this.firePositionOpenedEvent(position);
        } else {
            position.add(quantity, averagePrice);
            if (position.getQuantity() == 0L) {
                this.positions.remove(position.getSecurity());
                this.firePositionClosedEvent(position);
            } else {
                this.firePositionChangedEvent(position);
            }
        }
    }

    protected void firePositionOpenedEvent(Position position) {
        PositionEvent event = new PositionEvent(this, position);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IPositionListener)l[i]).positionOpened(event);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.core", "Error notifying listeners", t);
                CoreActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    protected void firePositionClosedEvent(Position position) {
        PositionEvent event = new PositionEvent(this, position);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IPositionListener)l[i]).positionClosed(event);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.core", "Error notifying listeners", t);
                CoreActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    protected void firePositionChangedEvent(Position position) {
        PositionEvent event = new PositionEvent(this, position);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IPositionListener)l[i]).positionChanged(event);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.core", "Error notifying listeners", t);
                CoreActivator.log((IStatus)status);
            }
            ++i;
        }
    }
}

