/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.simulation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.ats.simulation.Account;
import org.eclipsetrader.core.ats.simulation.OrderMonitor;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.trading.BrokerException;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderChangeListener;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderRoute;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IOrderStatus;
import org.eclipsetrader.core.trading.IOrderType;
import org.eclipsetrader.core.trading.IOrderValidity;
import org.eclipsetrader.core.trading.Order;
import org.eclipsetrader.core.trading.OrderChangeEvent;
import org.eclipsetrader.core.trading.OrderDelta;

public class Broker
implements IBroker {
    private final String id;
    private final IPricingEnvironment pricingEnvironment;
    private List<OrderMonitor> orders = new ArrayList<OrderMonitor>();
    private final ListenerList listeners = new ListenerList(1);
    private final Log log = LogFactory.getLog(this.getClass());
    private final IPricingListener pricingListener = new IPricingListener(){

        @Override
        public void pricingUpdate(PricingEvent event) {
            PricingDelta[] pricingDeltaArray = event.getDelta();
            int n = pricingDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                PricingDelta delta = pricingDeltaArray[n2];
                if (delta.getNewValue() instanceof ITrade) {
                    Broker.this.processTrade(event.getSecurity(), (ITrade)delta.getNewValue());
                }
                ++n2;
            }
        }
    };

    public Broker(IPricingEnvironment pricingEnvironment) {
        this.id = UUID.randomUUID().toString();
        this.pricingEnvironment = pricingEnvironment;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return "Simulation";
    }

    @Override
    public void connect() {
        this.pricingEnvironment.addPricingListener(this.pricingListener);
    }

    @Override
    public void disconnect() {
        this.pricingEnvironment.removePricingListener(this.pricingListener);
    }

    @Override
    public IOrderMonitor prepareOrder(IOrder order) throws BrokerException {
        if (order.getAccount() != null && !(order.getAccount() instanceof Account)) {
            throw new BrokerException("Invalid account");
        }
        OrderMonitor monitor = new OrderMonitor(this, order){

            @Override
            public void cancel() throws BrokerException {
                this.setStatus(IOrderStatus.Canceled);
                if (Broker.this.log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder("Order Cancelled:");
                    sb.append(" instrument=" + this.getOrder().getSecurity().getName());
                    sb.append(", type=" + this.getOrder().getType());
                    sb.append(", side=" + this.getOrder().getSide());
                    sb.append(", qty=" + this.getOrder().getQuantity());
                    if (this.getOrder().getPrice() != null) {
                        sb.append(", price=" + this.getOrder().getPrice());
                    }
                    if (this.getOrder().getReference() != null) {
                        sb.append(", reference=" + this.getOrder().getReference());
                    }
                    Broker.this.log.info((Object)sb.toString());
                }
                Broker.this.fireUpdateNotifications(new OrderDelta[]{new OrderDelta(3, this)});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void submit() throws BrokerException {
                List list = Broker.this.orders;
                synchronized (list) {
                    Broker.this.orders.add(this);
                }
                this.setId(UUID.randomUUID().toString());
                this.setStatus(IOrderStatus.PendingNew);
                if (Broker.this.log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder("Order Submitted:");
                    sb.append(" instrument=" + this.getOrder().getSecurity().getName());
                    sb.append(", type=" + this.getOrder().getType());
                    sb.append(", side=" + this.getOrder().getSide());
                    sb.append(", qty=" + this.getOrder().getQuantity());
                    if (this.getOrder().getPrice() != null) {
                        sb.append(", price=" + this.getOrder().getPrice());
                    }
                    if (this.getOrder().getReference() != null) {
                        sb.append(", reference=" + this.getOrder().getReference());
                    }
                    Broker.this.log.info((Object)sb.toString());
                }
                Broker.this.fireUpdateNotifications(new OrderDelta[]{new OrderDelta(3, this)});
            }
        };
        return monitor;
    }

    protected void fireUpdateNotifications(OrderDelta[] deltas) {
        if (deltas.length != 0) {
            OrderChangeEvent event = new OrderChangeEvent(this, deltas);
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                try {
                    ((IOrderChangeListener)l[i]).orderChanged(event);
                }
                catch (Throwable e) {
                    Status status = new Status(4, "org.eclipsetrader.core", 0, "Error running listener", e);
                    CoreActivator.log((IStatus)status);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOrderMonitor[] getOrders() {
        List<OrderMonitor> list = this.orders;
        synchronized (list) {
            return this.orders.toArray(new IOrderMonitor[this.orders.size()]);
        }
    }

    @Override
    public IOrderType[] getAllowedTypes() {
        return null;
    }

    @Override
    public IOrderSide[] getAllowedSides() {
        return null;
    }

    @Override
    public IOrderValidity[] getAllowedValidity() {
        return null;
    }

    @Override
    public IOrderRoute[] getAllowedRoutes() {
        return null;
    }

    @Override
    public boolean canTrade(ISecurity security) {
        return true;
    }

    @Override
    public ISecurity getSecurityFromSymbol(String symbol) {
        return null;
    }

    @Override
    public String getSymbolFromSecurity(ISecurity security) {
        return null;
    }

    @Override
    public void addOrderChangeListener(IOrderChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeOrderChangeListener(IOrderChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public IAccount[] getAccounts() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTrade(ISecurity security, ITrade trade) {
        OrderMonitor[] monitors;
        ArrayList<OrderDelta> deltas = new ArrayList<OrderDelta>();
        List<OrderMonitor> list = this.orders;
        synchronized (list) {
            monitors = this.orders.toArray(new OrderMonitor[this.orders.size()]);
        }
        int i = 0;
        while (i < monitors.length) {
            IOrder order;
            if ((monitors[i].getStatus() == IOrderStatus.PendingNew || monitors[i].getStatus() == IOrderStatus.Partial) && (order = monitors[i].getOrder()).getSecurity() == security) {
                if (order.getType() == IOrderType.Market) {
                    this.fillOrder(monitors[i], trade.getTime(), trade.getPrice());
                    deltas.add(new OrderDelta(3, monitors[i]));
                } else if (order.getType() == IOrderType.Limit) {
                    if (order.getSide() == IOrderSide.Buy && trade.getPrice() <= order.getPrice()) {
                        this.fillOrder(monitors[i], trade.getTime(), trade.getPrice());
                        deltas.add(new OrderDelta(3, monitors[i]));
                    } else if (order.getSide() == IOrderSide.Sell && trade.getPrice() >= order.getPrice()) {
                        this.fillOrder(monitors[i], trade.getTime(), trade.getPrice());
                        deltas.add(new OrderDelta(3, monitors[i]));
                    }
                }
            }
            ++i;
        }
        if (deltas.size() != 0) {
            this.fireUpdateNotifications(deltas.toArray(new OrderDelta[deltas.size()]));
        }
    }

    protected void fillOrder(OrderMonitor monitor, Date date, Double price) {
        ((Order)monitor.getOrder()).setDate(date);
        monitor.setFilledQuantity(monitor.getOrder().getQuantity());
        monitor.setAveragePrice(price);
        monitor.setStatus(IOrderStatus.Filled);
        if (this.log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Order Filled:");
            sb.append(" instrument=" + monitor.getOrder().getSecurity().getName());
            sb.append(", type=" + monitor.getOrder().getType());
            sb.append(", side=" + monitor.getOrder().getSide());
            sb.append(", qty=" + monitor.getOrder().getQuantity());
            if (monitor.getOrder().getPrice() != null) {
                sb.append(", price=" + monitor.getOrder().getPrice());
            }
            sb.append(", fillQty=" + monitor.getFilledQuantity());
            sb.append(", avgPrice=" + monitor.getAveragePrice());
            if (monitor.getOrder().getReference() != null) {
                sb.append(", reference=" + monitor.getOrder().getReference());
            }
            this.log.info((Object)sb.toString());
        }
        monitor.fireOrderCompletedEvent();
        Account account = (Account)monitor.getOrder().getAccount();
        if (account != null) {
            account.processCompletedOrder(monitor);
        }
    }
}

