/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.simulation;

import org.eclipse.core.runtime.ListenerList;
import org.eclipsetrader.core.ats.simulation.Broker;
import org.eclipsetrader.core.ats.simulation.Transaction;
import org.eclipsetrader.core.trading.BrokerException;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderMonitorListener;
import org.eclipsetrader.core.trading.IOrderStatus;
import org.eclipsetrader.core.trading.OrderMonitorEvent;

public class OrderMonitor
implements IOrderMonitor {
    private String id;
    private final Broker broker;
    private final IOrder order;
    private IOrderStatus status;
    private Long filledQuantity;
    private Double averagePrice;
    private Transaction transaction;
    private final ListenerList listeners = new ListenerList(1);

    public OrderMonitor(Broker broker, IOrder order) {
        this.broker = broker;
        this.order = order;
        this.status = IOrderStatus.New;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public IOrder getOrder() {
        return this.order;
    }

    @Override
    public IBroker getBrokerConnector() {
        return this.broker;
    }

    @Override
    public void addOrderMonitorListener(IOrderMonitorListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeOrderMonitorListener(IOrderMonitorListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void submit() throws BrokerException {
    }

    @Override
    public void cancel() throws BrokerException {
    }

    @Override
    public boolean allowModify() {
        return false;
    }

    @Override
    public void modify(IOrder order) throws BrokerException {
        throw new UnsupportedOperationException("Modify not allowed");
    }

    @Override
    public IOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(IOrderStatus status) {
        this.status = status;
    }

    @Override
    public Long getFilledQuantity() {
        return this.filledQuantity;
    }

    public void setFilledQuantity(Long filledQuantity) {
        this.filledQuantity = filledQuantity;
    }

    @Override
    public Double getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(Double averagePrice) {
        this.averagePrice = averagePrice;
    }

    @Override
    public String getMessage() {
        return null;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    protected void fireOrderCompletedEvent() {
        OrderMonitorEvent event = new OrderMonitorEvent(this, this.order);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IOrderMonitorListener)l[i]).orderCompleted(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public String toString() {
        return "OrderMonitor: status=" + this.getStatus() + ", filledQuantity=" + this.getFilledQuantity() + ", averagePrice=" + this.getAveragePrice() + " [" + this.order.toString() + "]";
    }
}

