/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.simulation;

import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.eclipsetrader.core.Cash;
import org.eclipsetrader.core.ats.simulation.OrderMonitor;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IStockTransaction;
import org.eclipsetrader.core.trading.ITransaction;

public class Transaction
implements ITransaction,
IStockTransaction {
    private final String id = UUID.randomUUID().toString();
    private final Date date;
    private final IOrder order;
    private final Long quantity;
    private final Double averagePrice;

    public Transaction(OrderMonitor orderMonitor, Date date) {
        this.date = date;
        this.order = orderMonitor.getOrder();
        this.quantity = orderMonitor.getFilledQuantity();
        this.averagePrice = orderMonitor.getAveragePrice();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getDescription() {
        return this.order.toString();
    }

    @Override
    public Cash getAmount() {
        Currency currency = (Currency)this.order.getSecurity().getAdapter(Currency.class);
        if (currency == null) {
            currency = Currency.getInstance(Locale.getDefault());
        }
        return new Cash((double)this.quantity.longValue() * this.averagePrice, currency);
    }

    @Override
    public IOrder getOrder() {
        return this.order;
    }

    @Override
    public ITransaction[] getTransactions() {
        return new ITransaction[0];
    }

    @Override
    public Long getFilledQuantity() {
        return this.quantity;
    }

    @Override
    public Double getAveragePrice() {
        return this.averagePrice;
    }
}

