/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.charts;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.IDataSeriesVisitor;
import org.eclipsetrader.core.feed.IBar;
import org.eclipsetrader.core.feed.IOHLC;

public class BarsDataSeries
implements IDataSeries {
    private final String name;
    private final List<IBar> bars;
    private IAdaptable first;
    private IAdaptable last;
    private IAdaptable highest;
    private IAdaptable lowest;
    private int lastIndex;
    private boolean highestOverride = false;
    private boolean lowestOverride = false;

    public BarsDataSeries(String name, List<IBar> bars) {
        this.name = name;
        this.bars = bars;
        this.accept(new RangeVisitor());
        this.lastIndex = bars.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IAdaptable getFirst() {
        this.checkNewValues();
        return this.first;
    }

    @Override
    public IAdaptable getLast() {
        this.checkNewValues();
        return this.last;
    }

    @Override
    public IAdaptable getHighest() {
        this.checkNewValues();
        return this.highest;
    }

    public void setHighest(IAdaptable highest) {
        this.highest = highest;
        this.highestOverride = true;
    }

    protected boolean isHighestOverride() {
        return this.highestOverride;
    }

    @Override
    public IAdaptable getLowest() {
        this.checkNewValues();
        return this.lowest;
    }

    public void setLowest(IAdaptable lowest) {
        this.lowest = lowest;
        this.lowestOverride = true;
    }

    protected boolean isLowestOverride() {
        return this.lowestOverride;
    }

    @Override
    public int size() {
        return this.bars.size();
    }

    @Override
    public IAdaptable[] getValues() {
        return this.bars.toArray(new IAdaptable[this.bars.size()]);
    }

    @Override
    public IDataSeries getSeries(IAdaptable first, IAdaptable last) {
        DataSeries series = new DataSeries(this.getName(), this.getSubset(first, last));
        if (this.highestOverride) {
            series.setHighest(this.getHighest());
        }
        if (this.lowestOverride) {
            series.setLowest(this.getLowest());
        }
        return series;
    }

    protected IAdaptable[] getSubset(IAdaptable first, IAdaptable last) {
        Date firstValue = first != null ? (Date)first.getAdapter(Date.class) : null;
        Date lastValue = last != null ? (Date)last.getAdapter(Date.class) : null;
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>(this.bars.size());
        int i = 0;
        while (i < this.bars.size()) {
            Date date = (Date)this.bars.get(i).getAdapter(Date.class);
            if (!(firstValue != null && date.before(firstValue) || lastValue != null && date.after(lastValue))) {
                list.add(this.bars.get(i));
            }
            ++i;
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    @Override
    public int cross(IDataSeries series, IAdaptable value) {
        if (this.bars.size() <= 1 || series.size() <= 1) {
            return 0;
        }
        int index = this.indexOf(this, value);
        if (index <= 0) {
            return 0;
        }
        int otherIndex = this.indexOf(series, value);
        if (otherIndex <= 0) {
            return 0;
        }
        Number ourValue = (Number)this.bars.get(index - 1).getAdapter(Number.class);
        Number ourNextValue = (Number)this.bars.get(index).getAdapter(Number.class);
        Number otherValue = (Number)series.getValues()[otherIndex - 1].getAdapter(Number.class);
        Number otherNextValue = (Number)series.getValues()[otherIndex].getAdapter(Number.class);
        if (ourValue.doubleValue() < otherValue.doubleValue() && ourNextValue.doubleValue() > otherNextValue.doubleValue()) {
            return 1;
        }
        if (ourValue.doubleValue() > otherValue.doubleValue() && ourNextValue.doubleValue() < otherNextValue.doubleValue()) {
            return -1;
        }
        return 0;
    }

    protected int indexOf(IDataSeries series, IAdaptable value) {
        IAdaptable[] values = series.getValues();
        Date valueDate = (Date)value.getAdapter(Date.class);
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                return i;
            }
            Date date = (Date)values[i].getAdapter(Date.class);
            if (date != null && date.equals(valueDate)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IDataSeries[] getChildren() {
        return null;
    }

    @Override
    public void setChildren(IDataSeries[] childrens) {
    }

    @Override
    public void accept(IDataSeriesVisitor visitor) {
        visitor.visit(this);
    }

    private void checkNewValues() {
        if (this.lastIndex == this.bars.size()) {
            return;
        }
        this.accept(new RangeVisitor());
        this.lastIndex = this.bars.size();
    }

    private class RangeVisitor
    implements IDataSeriesVisitor {
        private Double lowestValue;
        private Double highestValue;
        private Date firstValue;
        private Date lastValue;

        @Override
        public boolean visit(IDataSeries data) {
            IAdaptable[] iAdaptableArray = data.getValues();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable v = iAdaptableArray[n2];
                IOHLC ohlc = (IOHLC)v.getAdapter(IOHLC.class);
                if (ohlc != null) {
                    this.updateHighestLowest(ohlc.getLow() != null ? ohlc.getLow() : ohlc.getClose(), v);
                    this.updateHighestLowest(ohlc.getHigh() != null ? ohlc.getHigh() : ohlc.getClose(), v);
                    if (ohlc.getDate() != null) {
                        this.updateFirstLast(ohlc.getDate(), v);
                    }
                } else {
                    Number value = (Number)v.getAdapter(Number.class);
                    this.updateHighestLowest(value, v);
                    Date date = (Date)v.getAdapter(Date.class);
                    if (date != null) {
                        this.updateFirstLast(date, v);
                    }
                }
                ++n2;
            }
            if (data instanceof BarsDataSeries) {
                if (((BarsDataSeries)data).highestOverride) {
                    BarsDataSeries.this.highest = data.getHighest();
                }
                if (((BarsDataSeries)data).lowestOverride) {
                    BarsDataSeries.this.lowest = data.getLowest();
                }
            }
            return true;
        }

        private void updateHighestLowest(Number value, IAdaptable reference) {
            if (this.lowestValue == null || value.doubleValue() < this.lowestValue) {
                this.lowestValue = value.doubleValue();
                BarsDataSeries.this.lowest = reference;
            }
            if (this.highestValue == null || value.doubleValue() > this.highestValue) {
                this.highestValue = value.doubleValue();
                BarsDataSeries.this.highest = reference;
            }
        }

        private void updateFirstLast(Date date, IAdaptable reference) {
            if (this.firstValue == null || date.before(this.firstValue)) {
                this.firstValue = date;
                BarsDataSeries.this.first = reference;
            }
            if (this.lastValue == null || date.after(this.lastValue)) {
                this.lastValue = date;
                BarsDataSeries.this.last = reference;
            }
        }
    }
}

