/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.charts;

import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.IDataSeriesVisitor;

public class DataSeriesSubsetVisitor
implements IDataSeriesVisitor {
    private IAdaptable first;
    private IAdaptable last;
    private IDataSeries subset;

    public DataSeriesSubsetVisitor(IAdaptable first, IAdaptable last) {
        this.first = first;
        this.last = last;
    }

    public DataSeriesSubsetVisitor(Date first, Date last) {
        this.first = new DateWrapper(first);
        this.last = new DateWrapper(last);
    }

    @Override
    public boolean visit(IDataSeries data) {
        this.subset = data.getSeries(this.first, this.last);
        IDataSeries[] childs = data.getChildren();
        if (childs != null) {
            IDataSeries[] childSubsets = new IDataSeries[childs.length];
            int i = 0;
            while (i < childs.length) {
                DataSeriesSubsetVisitor visitor = new DataSeriesSubsetVisitor(this.first, this.last);
                visitor.visit(childs[i]);
                childSubsets[i] = visitor.getSubset();
                ++i;
            }
            this.subset.setChildren(childSubsets);
        }
        return false;
    }

    public IDataSeries getSubset() {
        return this.subset;
    }

    private class DateWrapper
    implements IAdaptable {
        private Date value;

        public DateWrapper(Date value) {
            this.value = value;
        }

        public Object getAdapter(Class adapter) {
            if (this.value != null && adapter.isAssignableFrom(this.value.getClass())) {
                return this.value;
            }
            return null;
        }
    }
}

