/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;

public class HistoryDay
implements IHistory {
    private ISecurity security;
    private IOHLC[] bars = new IOHLC[0];
    private TimeSpan timeSpan;
    private IOHLC highest;
    private IOHLC lowest;
    private Map<Date, StoreObject> storeObjects = new TreeMap<Date, StoreObject>();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected HistoryDay() {
    }

    public HistoryDay(ISecurity security, TimeSpan timeSpan) {
        this.security = security;
        this.timeSpan = timeSpan;
    }

    public HistoryDay(ISecurity security, TimeSpan timeSpan, IStore[] store, IStoreProperties[] storeProperties) {
        this.security = security;
        this.timeSpan = timeSpan;
        this.setStoreProperties(store, storeProperties);
    }

    public HistoryDay(ISecurity security, TimeSpan timeSpan, IOHLC[] bars) {
        this.security = security;
        this.timeSpan = timeSpan;
        this.bars = bars;
    }

    @Override
    public IOHLC[] getAdjustedOHLC() {
        return this.bars;
    }

    @Override
    public IOHLC getFirst() {
        return this.bars != null && this.bars.length != 0 ? this.bars[0] : null;
    }

    @Override
    public IOHLC getHighest() {
        return this.highest;
    }

    @Override
    public IOHLC getLast() {
        return this.bars != null && this.bars.length != 0 ? this.bars[this.bars.length - 1] : null;
    }

    @Override
    public IOHLC getLowest() {
        return this.lowest;
    }

    @Override
    public IOHLC[] getOHLC() {
        return this.bars;
    }

    public void setOHLC(IOHLC[] bars) {
        if (Arrays.equals(this.bars, bars)) {
            return;
        }
        IOHLC[] oldBars = this.bars;
        ArrayList<IOHLC> l = new ArrayList<IOHLC>(Arrays.asList(bars));
        Collections.sort(l, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        this.bars = l.toArray(new IOHLC[l.size()]);
        this.updateStoreObjects();
        this.updateRange();
        this.propertyChangeSupport.firePropertyChange("bars", oldBars, this.bars);
    }

    protected IStoreObject[] updateStoreObjects() {
        IStore store;
        HashSet<StoreObject> updatedStoreObjects = new HashSet<StoreObject>();
        IRepository repository = null;
        if (this.storeObjects.size() != 0 && (store = this.storeObjects.values().iterator().next().getStore()) != null) {
            repository = store.getRepository();
        }
        if (this.bars.length != 0) {
            Calendar c = Calendar.getInstance();
            int dayOfYear = -1;
            Date date = null;
            ArrayList<IOHLC> list = new ArrayList<IOHLC>(2048);
            IOHLC[] iOHLCArray = this.bars;
            int n = this.bars.length;
            int n2 = 0;
            while (n2 < n) {
                IOHLC d = iOHLCArray[n2];
                c.setTime(d.getDate());
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                if (c.get(6) != dayOfYear) {
                    if (list.size() != 0 && date != null) {
                        IStoreProperties properties;
                        StoreObject object = this.storeObjects.get(date);
                        if (object == null) {
                            properties = new StoreProperties();
                            properties.setProperty("type", IHistory.class.getName());
                            properties.setProperty("security", this.security);
                            properties.setProperty("bars-date", date);
                            properties.setProperty(this.timeSpan.toString(), list.toArray(new IOHLC[list.size()]));
                            object = new StoreObject(repository != null ? repository.createObject() : null, properties);
                            this.storeObjects.put(date, object);
                            updatedStoreObjects.add(object);
                        } else {
                            properties = object.getStoreProperties();
                            properties.setProperty(this.timeSpan.toString(), list.toArray(new IOHLC[list.size()]));
                            object.setStoreProperties(properties);
                            updatedStoreObjects.add(object);
                        }
                        list = new ArrayList(2048);
                    }
                    dayOfYear = c.get(6);
                }
                list.add(d);
                date = c.getTime();
                ++n2;
            }
            if (list.size() != 0 && date != null) {
                StoreObject object = this.storeObjects.get(date);
                if (object == null) {
                    StoreProperties properties = new StoreProperties();
                    properties.setProperty("type", IHistory.class.getName());
                    properties.setProperty("security", this.security);
                    properties.setProperty("bars-date", date);
                    properties.setProperty(this.timeSpan.toString(), list.toArray(new IOHLC[list.size()]));
                    object = new StoreObject(repository != null ? repository.createObject() : null, properties);
                    this.storeObjects.put(date, object);
                    updatedStoreObjects.add(object);
                } else {
                    IStoreProperties properties = object.getStoreProperties();
                    properties.setProperty(this.timeSpan.toString(), list.toArray(new IOHLC[list.size()]));
                    object.setStoreProperties(properties);
                    updatedStoreObjects.add(object);
                }
            }
        }
        return updatedStoreObjects.toArray(new IStoreObject[updatedStoreObjects.size()]);
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    protected void setSecurity(ISecurity security) {
        this.security = security;
    }

    @Override
    public ISplit[] getSplits() {
        return null;
    }

    public void setSplits(ISplit[] splits) {
    }

    @Override
    public IHistory getSubset(Date first, Date last) {
        ArrayList<IOHLC> l = new ArrayList<IOHLC>();
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC b = iOHLCArray[n2];
            if (!(first != null && b.getDate().before(first) || last != null && b.getDate().after(last))) {
                l.add(b);
            }
            ++n2;
        }
        return new HistoryDay(this.security, this.timeSpan, l.toArray(new IOHLC[l.size()]));
    }

    @Override
    public IHistory getSubset(Date first, Date last, TimeSpan aggregation) {
        if (this.timeSpan != null && this.timeSpan.equals(aggregation)) {
            return this.getSubset(first, last);
        }
        return null;
    }

    @Override
    public IHistory[] getDay(Date date) {
        return null;
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        if (adapter.isAssignableFrom(IStoreObject[].class)) {
            Collection<StoreObject> c = this.storeObjects.values();
            return c.toArray(new IStoreObject[c.size()]);
        }
        return null;
    }

    public void setStoreProperties(IStore[] store, IStoreProperties[] storeProperties) {
        Assert.isTrue((store.length == storeProperties.length ? 1 : 0) != 0, (String)"IStore and IStoreProperties arrays must be of same size!");
        this.storeObjects.clear();
        if (storeProperties.length != 0) {
            this.security = (ISecurity)storeProperties[0].getProperty("security");
        }
        ArrayList<IOHLC> l1 = new ArrayList<IOHLC>(2048);
        int i = 0;
        while (i < store.length) {
            IOHLC[] minuteBars;
            StoreObject object = new StoreObject(store[i], storeProperties[i]);
            Date date = (Date)storeProperties[i].getProperty("bars-date");
            this.storeObjects.put(date, object);
            IOHLC[] bars = (IOHLC[])storeProperties[i].getProperty(this.timeSpan.toString());
            if (bars == null && (minuteBars = this.getLowestTimespanBars(storeProperties[i])) != null) {
                Date startDate = null;
                Date endDate = null;
                Double open = null;
                Double high = null;
                Double low = null;
                Double close = null;
                Long volume = 0L;
                Calendar c = Calendar.getInstance();
                ArrayList<OHLC> l = new ArrayList<OHLC>();
                IOHLC[] iOHLCArray = minuteBars;
                int n = minuteBars.length;
                int n2 = 0;
                while (n2 < n) {
                    IOHLC currentBar = iOHLCArray[n2];
                    if (startDate != null && !currentBar.getDate().before(endDate)) {
                        l.add(new OHLC(startDate, open, high, low, close, volume));
                        startDate = null;
                    }
                    if (startDate == null) {
                        c.setTime(currentBar.getDate());
                        startDate = c.getTime();
                        c.add(12, this.timeSpan.getLength());
                        endDate = c.getTime();
                        close = null;
                        low = null;
                        high = null;
                        open = null;
                        volume = 0L;
                    }
                    if (open == null) {
                        open = currentBar.getOpen();
                    }
                    high = high != null ? Math.max(high, currentBar.getHigh()) : currentBar.getHigh();
                    low = low != null ? Math.min(low, currentBar.getLow()) : currentBar.getLow();
                    close = currentBar.getClose();
                    volume = volume + currentBar.getVolume();
                    ++n2;
                }
                if (startDate != null) {
                    l.add(new OHLC(startDate, open, high, low, close, volume));
                }
                bars = l.toArray(new IOHLC[l.size()]);
            }
            if (bars != null) {
                l1.addAll(Arrays.asList(bars));
            }
            ++i;
        }
        Collections.sort(l1, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        Object[] newBars = l1.toArray(new IOHLC[l1.size()]);
        if (Arrays.equals(this.bars, newBars)) {
            return;
        }
        IOHLC[] oldBars = this.bars;
        this.bars = newBars;
        this.updateRange();
        this.propertyChangeSupport.firePropertyChange("bars", oldBars, this.bars);
    }

    IOHLC[] getLowestTimespanBars(IStoreProperties storeProperties) {
        TimeSpan lowestTimeSpan = null;
        String[] stringArray = storeProperties.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            TimeSpan propertyTimeSpan = TimeSpan.fromString(name);
            if (propertyTimeSpan != null && propertyTimeSpan.lowerThan(this.timeSpan) && (lowestTimeSpan == null || propertyTimeSpan.lowerThan(lowestTimeSpan))) {
                lowestTimeSpan = propertyTimeSpan;
            }
            ++n2;
        }
        if (lowestTimeSpan != null) {
            return (IOHLC[])storeProperties.getProperty(lowestTimeSpan.toString());
        }
        return null;
    }

    protected void updateRange() {
        this.highest = null;
        this.lowest = null;
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC b = iOHLCArray[n2];
            if (this.highest == null || b.getHigh() > this.highest.getHigh()) {
                this.highest = b;
            }
            if (this.lowest == null || b.getLow() < this.lowest.getLow()) {
                this.lowest = b;
            }
            ++n2;
        }
    }

    private class StoreObject
    implements IStoreObject {
        private IStore store;
        private IStoreProperties storeProperties;

        public StoreObject(IStore store, IStoreProperties storeProperties) {
            this.store = store;
            this.storeProperties = storeProperties;
        }

        @Override
        public IStore getStore() {
            return this.store;
        }

        @Override
        public IStoreProperties getStoreProperties() {
            return this.storeProperties;
        }

        @Override
        public void setStore(IStore store) {
            this.store = store;
        }

        @Override
        public void setStoreProperties(IStoreProperties storeProperties) {
            this.storeProperties = storeProperties;
        }
    }
}

