/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.io.Serializable;
import org.eclipsetrader.core.feed.IQuote;

public class Quote
implements IQuote,
Serializable {
    private static final long serialVersionUID = 4237311627623138246L;
    private Double bid;
    private Double ask;
    private Long bidSize;
    private Long askSize;

    public Quote(Double bid, Double ask, Long bidSize, Long askSize) {
        this.bid = bid;
        this.ask = ask;
        this.bidSize = bidSize;
        this.askSize = askSize;
    }

    public Quote(Double bid, Double ask) {
        this.bid = bid;
        this.ask = ask;
    }

    @Override
    public Double getAsk() {
        return this.ask;
    }

    @Override
    public Long getAskSize() {
        return this.askSize;
    }

    @Override
    public Double getBid() {
        return this.bid;
    }

    @Override
    public Long getBidSize() {
        return this.bidSize;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IQuote)) {
            return false;
        }
        IQuote other = (IQuote)obj;
        return this.equals(this.getBid(), other.getBid()) && this.equals(this.getAsk(), other.getAsk()) && this.equals(this.getBidSize(), other.getBidSize()) && this.equals(this.getAskSize(), other.getAskSize());
    }

    protected boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public int hashCode() {
        return 3 * (this.bid != null ? this.bid.hashCode() : 0) + 7 * (this.ask != null ? this.ask.hashCode() : 0) + 11 * (this.bidSize != null ? this.bidSize.hashCode() : 0) + 13 * (this.askSize != null ? this.askSize.hashCode() : 0);
    }

    public String toString() {
        return "[Quote: B=" + this.bid + " BS=" + this.bidSize + " A=" + this.ask + " AS=" + this.askSize + "]";
    }
}

